/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.persistence;

import com.bwanms.model.lock.DBLock;
import com.bwanms.persistence.PrivateSessionManager;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;

public class SessionLockHelper {
    private static final int MAX_LOCK_WAIT_TIME = 60000;
    private static final Logger logger = Logger.getLogger(SessionLockHelper.class);

    public static void lock(Session session, String lockName) {
        long _time = System.currentTimeMillis();
        logger.debug((Object)("[" + lockName + "] lock"));
        while (!SessionLockHelper.lockImpl(session, lockName)) {
            if (System.currentTimeMillis() - _time <= 60000L) continue;
            throw new HibernateException("Timed out while trying to get lock [" + lockName + "]");
        }
        logger.debug((Object)("[" + lockName + "] locked"));
    }

    private static boolean lockImpl(Session session, String key) {
        block4: {
            try {
                DBLock dbLock = (DBLock)session.createQuery("from " + DBLock.class.getName() + " as d where name = :name").setString("name", key).setLockMode("d", LockMode.UPGRADE).uniqueResult();
                if (dbLock != null) break block4;
                try {
                    SessionLockHelper.createDBLock(key);
                }
                catch (HibernateException e) {
                    logger.debug((Object)e, (Throwable)e);
                }
                return false;
            }
            catch (HibernateException e) {
                logger.debug((Object)e, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static DBLock createDBLock(String key) {
        Session session = null;
        try {
            session = PrivateSessionManager.privateSession();
            logger.debug((Object)("[" + key + "] create"));
            DBLock dbLock = new DBLock(key);
            dbLock.setLastLockTime(System.currentTimeMillis());
            session.save((Object)dbLock);
            PrivateSessionManager.commit(session);
            DBLock dBLock = dbLock;
            return dBLock;
        }
        catch (Exception e) {
            if (e instanceof HibernateException) {
                throw (HibernateException)((Object)e);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

