/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.persistence;

import com.bwanms.persistence.Datastore;
import com.bwanms.persistence.SessionManager;
import com.bwanms.util.PlatformConfiguration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceTransactionManagementInterceptor {
    private static final Logger log = Logger.getLogger(ServiceTransactionManagementInterceptor.class);
    private static ServiceTransactionManagementInterceptor instance = null;

    public static Object install(Object service, Class serviceIf) {
        return Proxy.newProxyInstance(serviceIf.getClassLoader(), new Class[]{serviceIf}, ServiceTransactionManagementInterceptor.instance().createInvocationHandler(service));
    }

    private static ServiceTransactionManagementInterceptor instance() {
        if (instance == null) {
            try {
                instance = (ServiceTransactionManagementInterceptor)PlatformConfiguration.instance().getServiceTransactionManagementInterceptorImpl().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public abstract InvocationHandler createInvocationHandler(Object var1);

    protected static SessionManager getDatastoreSessionManager() {
        return Datastore.instance().getSessionManager();
    }

    protected static List<Runnable> getOperationsAfterTransaction() {
        return Datastore.getOperationsAfterTransaction();
    }

    protected static List<Runnable> getOperationsBeforeTransaction() {
        return Datastore.getOperationsBeforeTransaction();
    }

    protected static List<Runnable> getFinallyOperations(Transaction tx) {
        return Datastore.getFinallyOperations(tx);
    }

    protected static void cleanupTransactionContext(Transaction tx) {
        Datastore.cleanupTransactionContext(tx);
    }
}

