/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.persistence;

import com.bwanms.persistence.PrivateSessionFactoryHelper;
import java.util.HashMap;
import java.util.IdentityHashMap;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

public class PrivateSessionManager {
    private static final Logger log = Logger.getLogger(PrivateSessionManager.class);
    private static PrivateSessionManager instance;
    private static SessionFactory sessionFactory;
    private static IdentityHashMap<Object, org.hibernate.Session> identityHashMap;

    public static org.hibernate.Session getSession(Object service) {
        return PrivateSessionManager.instance().getSessionInstance(service);
    }

    public static org.hibernate.Session newSession() {
        return sessionFactory.openSession();
    }

    public static boolean hasSession(Object service) {
        return false;
    }

    public static org.hibernate.Session session(Object service) {
        org.hibernate.Session session = identityHashMap.get(service);
        if (session == null) {
            throw new RuntimeException("Session not started for " + service);
        }
        return session;
    }

    private org.hibernate.Session getSessionInstance(Object service) {
        Session session;
        if (identityHashMap.containsKey(service)) {
            session = identityHashMap.get(service);
        } else {
            session = sessionFactory.openSession();
            identityHashMap.put(service, (org.hibernate.Session)session);
            log.info((Object)("STARTED SESSION " + session + " for service " + service));
        }
        return session;
    }

    private static PrivateSessionManager instance() {
        if (instance == null) {
            instance = new PrivateSessionManager();
        }
        return instance;
    }

    public static void endSession(Object service) {
        PrivateSessionManager.instance().endSessionInstance(service);
    }

    private void endSessionInstance(Object service) {
        org.hibernate.Session session = identityHashMap.remove(service);
        if (session == null) {
            log.warn((Object)("Attempted to close session for unassociated service " + service.getClass().getName()));
        }
        session.close();
    }

    public static org.hibernate.Session privateSession() {
        Session session = sessionFactory.openSession();
        session.beginTransaction();
        return session;
    }

    public static void commit(org.hibernate.Session session) throws Exception {
        Transaction tx = session.getTransaction();
        try {
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    static {
        identityHashMap = new IdentityHashMap(new HashMap());
        sessionFactory = PrivateSessionFactoryHelper.getSessionFactory();
    }
}

