/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.persistence;

import com.bwanms.persistence.PrivateSessionManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;

public class PrivateSessionHelper {
    public static void deleteAndCommit(Object ... objects) {
        Session session = null;
        try {
            session = PrivateSessionManager.privateSession();
            for (Object object : objects) {
                if (object instanceof Collection) {
                    for (Object lObject : (Collection)object) {
                        session.delete(lObject);
                    }
                    continue;
                }
                session.delete(object);
            }
            PrivateSessionManager.commit(session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static synchronized void persistAndCommit(Object object) {
        PrivateSessionHelper.persistAndCommit(new Object[]{object});
    }

    public static synchronized void persistAndCommit(Object ... objects) {
        Session session = null;
        try {
            session = PrivateSessionManager.privateSession();
            for (Object object : objects) {
                session.saveOrUpdate(object);
            }
            PrivateSessionManager.commit(session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static synchronized Object getAndCloseSession(Class clazz, long id) {
        Object returnValue = null;
        Session session = null;
        try {
            session = PrivateSessionManager.privateSession();
            returnValue = session.get(clazz, (Serializable)Long.valueOf(id));
            PrivateSessionManager.commit(session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return returnValue;
    }

    public static synchronized List performQuery(String query) {
        List returnValue = new ArrayList();
        Session session = null;
        try {
            session = PrivateSessionManager.privateSession();
            returnValue = session.createQuery(query).list();
            PrivateSessionManager.commit(session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List performSQLQuery(String query) throws Exception {
        List returnValue;
        Session session = null;
        try {
            session = PrivateSessionManager.privateSession();
            returnValue = session.createSQLQuery(query).list();
            PrivateSessionManager.commit(session);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return returnValue;
    }
}

