/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.persistence;

import com.bwanms.persistence.PrivateSessionManager;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.jboss.hibernate.session.TransactionNotSupportedException;

public class MBeanTransactionManagementInterceptor {
    private static final Logger log = Logger.getLogger(MBeanTransactionManagementInterceptor.class);

    public static Object install(Object service, Class serviceIf) {
        return Proxy.newProxyInstance(serviceIf.getClassLoader(), new Class[]{serviceIf}, (InvocationHandler)new ServiceMethodInvocationHandler(service));
    }

    private static class ServiceMethodInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final Logger log = Logger.getLogger(ServiceMethodInvocationHandler.class);
        private Object service;

        public ServiceMethodInvocationHandler(Object service) {
            this.service = service;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object object;
            Object tx = null;
            boolean newSession = false;
            try {
                try {
                    Object res;
                    Session session = null;
                    newSession = !PrivateSessionManager.hasSession(this.service);
                    session = PrivateSessionManager.getSession(this.service);
                    log.debug((Object)("SESSION(" + (newSession ? "new" : "not new") + ")----------------->"));
                    if (newSession) {
                        tx = session.beginTransaction();
                        log.debug((Object)(Thread.currentThread() + " " + method.getDeclaringClass().getName() + "." + method.getName() + " got Transaction " + tx.toString()));
                    }
                    object = res = method.invoke(this.service, args);
                    Object var10_12 = null;
                    if (!newSession) return object;
                }
                catch (HibernateException e) {
                    Object res;
                    if (!(e instanceof TransactionNotSupportedException)) throw new RuntimeException(e);
                    Object object2 = res = method.invoke(this.service, args);
                    Object var10_13 = null;
                    if (!newSession) return object2;
                    try {
                        if (tx != null) {
                            log.debug((Object)(Thread.currentThread() + " " + method.getDeclaringClass().getName() + "." + method.getName() + " is about to commit Transaction " + tx.toString()));
                            tx.commit();
                        }
                    }
                    catch (Throwable x) {
                        tx.rollback();
                        throw x;
                    }
                    PrivateSessionManager.endSession(this.service);
                    log.debug((Object)"-----------------> SESSION CLOSED");
                    return object2;
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (!newSession) throw throwable;
                try {}
                catch (Throwable x) {
                    tx.rollback();
                    throw x;
                }
                if (tx != null) {
                    log.debug((Object)(Thread.currentThread() + " " + method.getDeclaringClass().getName() + "." + method.getName() + " is about to commit Transaction " + tx.toString()));
                    tx.commit();
                }
                PrivateSessionManager.endSession(this.service);
                log.debug((Object)"-----------------> SESSION CLOSED");
                throw throwable;
            }
            try {}
            catch (Throwable x) {
                tx.rollback();
                throw x;
            }
            if (tx != null) {
                log.debug((Object)(Thread.currentThread() + " " + method.getDeclaringClass().getName() + "." + method.getName() + " is about to commit Transaction " + tx.toString()));
                tx.commit();
            }
            PrivateSessionManager.endSession(this.service);
            log.debug((Object)"-----------------> SESSION CLOSED");
            return object;
        }
    }
}

