/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.persistence;

import com.bwanms.persistence.SessionManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class JbossHibernateSessionManager
extends SessionManager {
    private static final Logger log = Logger.getLogger(JbossHibernateSessionManager.class);

    public Session getSession() {
        return JbossHibernateSessionManager.generateSession("java:/bwanms/HibernateSessionFactory");
    }

    private static Session generateSession(String name) throws HibernateException {
        SessionFactory factory = JbossHibernateSessionManager.locateSessionFactory(name);
        return factory.getCurrentSession();
    }

    private static SessionFactory locateSessionFactory(String name) throws HibernateException {
        InitialContext context = null;
        try {
            SessionFactory factory;
            context = new InitialContext();
            SessionFactory sessionFactory = factory = (SessionFactory)context.lookup(name);
            return sessionFactory;
        }
        catch (NamingException e) {
            throw new HibernateException("Unable to locate SessionFactory in JNDI under name [" + name + "]", (Throwable)e);
        }
        finally {
            JbossHibernateSessionManager.release(context);
        }
    }

    private static void release(InitialContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                log.info((Object)"Unable to release context", t);
            }
        }
    }

    public void startSession() {
    }

    public void endSession() {
    }
}

