/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.persistence;

import com.bwanms.persistence.SessionLockHelper;
import com.bwanms.persistence.SessionManager;
import com.bwanms.util.PlatformConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Datastore {
    private static final Logger log = Logger.getLogger(Datastore.class);
    private static Datastore instance;
    private SessionManager sessionManager = (SessionManager)PlatformConfiguration.instance().getPersistenceSessionManagerImpl().newInstance();
    private static Map<Transaction, ArrayList<Runnable>> beforeCommitOperations;
    private static Map<Transaction, ArrayList<Runnable>> afterCommitOperations;
    private static Map<Transaction, ArrayList<Runnable>> finallyOperations;
    private static Map<Transaction, Map<String, Object>> transactionContext;

    private Datastore() throws Exception {
    }

    public static Session session() {
        return Datastore.instance().getSessionManager().getSession();
    }

    static synchronized Datastore instance() {
        try {
            if (instance == null) {
                instance = new Datastore();
            }
            return instance;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public static void addOperationBeforeTransaction(Runnable runnable) {
        if (beforeCommitOperations.get(Datastore.session().getTransaction()) == null) {
            beforeCommitOperations.put(Datastore.session().getTransaction(), new ArrayList());
        }
        beforeCommitOperations.get(Datastore.session().getTransaction()).add(runnable);
    }

    static List<Runnable> getOperationsBeforeTransaction() {
        return beforeCommitOperations.remove(Datastore.session().getTransaction());
    }

    static List<Runnable> getOperationsBeforeTransaction(Transaction tx) {
        return beforeCommitOperations.remove(tx);
    }

    public static void addOperationAfterTransaction(Runnable runnable) {
        if (afterCommitOperations.get(Datastore.session().getTransaction()) == null) {
            afterCommitOperations.put(Datastore.session().getTransaction(), new ArrayList());
        }
        afterCommitOperations.get(Datastore.session().getTransaction()).add(runnable);
    }

    static List<Runnable> getOperationsAfterTransaction() {
        return afterCommitOperations.remove(Datastore.session().getTransaction());
    }

    static List<Runnable> getOperationsAfterTransaction(Transaction tx) {
        return afterCommitOperations.remove(tx);
    }

    public static void addFinallyOperation(Runnable runnable) {
        if (finallyOperations.get(Datastore.session().getTransaction()) == null) {
            finallyOperations.put(Datastore.session().getTransaction(), new ArrayList());
        }
        finallyOperations.get(Datastore.session().getTransaction()).add(runnable);
    }

    static List<Runnable> getFinallyOperations(Transaction tx) {
        return finallyOperations.remove(tx);
    }

    private static Map<String, Object> transactionContext() {
        if (transactionContext.get(Datastore.session().getTransaction()) == null) {
            transactionContext.put(Datastore.session().getTransaction(), new HashMap());
        }
        return transactionContext.get(Datastore.session().getTransaction());
    }

    public static Object addToTransactionContext(String key, Object value) {
        Object previous = Datastore.transactionContext().remove(key);
        Datastore.transactionContext().put(key, value);
        return previous;
    }

    public static Object getFromTransactionContext(String key) {
        return Datastore.transactionContext().get(key);
    }

    public static Object removeFromTransactionContext(String key) {
        return Datastore.transactionContext().remove(key);
    }

    static Map<String, Object> cleanupTransactionContext(Transaction tx) {
        Datastore.getOperationsBeforeTransaction(tx);
        Datastore.getOperationsAfterTransaction(tx);
        return transactionContext.remove(tx);
    }

    public static void lock(String lockName) {
        SessionLockHelper.lock(Datastore.session(), lockName);
    }

    static {
        beforeCommitOperations = new HashMap<Transaction, ArrayList<Runnable>>();
        afterCommitOperations = new HashMap<Transaction, ArrayList<Runnable>>();
        finallyOperations = new HashMap<Transaction, ArrayList<Runnable>>();
        transactionContext = new HashMap<Transaction, Map<String, Object>>();
    }
}

