/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerFilterView;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.model.Task;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.performance.viewer.PerformanceCollectionExportView;
import com.bwanms.performance.viewer.PerformanceCollectionGraphView;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FrameUtil;
import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceViewerManagerConfig
extends EntityManagerConfig {
    private static Internationalizer ddI18N = Internationalizer.getInternationalizer("com.bwanms.performance.perfTaskTranslation");
    private static Internationalizer i18n = Internationalizer.getInternationalizer(PerformanceViewerManagerConfig.class);
    private static String[] columnNames = new String[]{"Name", "Type", "Created", "PollingInterval(min)", "Status"};
    private static String[] columnAttribNames = new String[]{"Name", "EntityType", "CreatedDate", "PollingInterval", "State"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public PerformanceViewerManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], columnAttribNames[2], i18n.translateString(columnNames[2]), new EntityManagerRowComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], columnAttribNames[3], i18n.translateString(columnNames[3]), new EntityManagerRowComparator(3)));
        this.columns.add(new EntityManagerColumn(columnNames[4], columnAttribNames[4], i18n.translateString(columnNames[4]), new EntityManagerRowDisplayComparator(4)));
        this.entityRowProvider = new PerformanceViewerRowProvider(PerformanceViewerManagerConfig.getColumnAttributeNames(this.columns));
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new PerformanceViewerManagerAction("Graph", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new PerformanceViewerManagerAction("Export", 1));
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria("Name", "name", 1, 1, null, false));
        Vector<Object> items = new Vector<Object>();
        for (String entityType : PMCollectionEntityTypeUtil.getAvailableEntityTypes()) {
            items.add(new ComboItem(entityType, ddI18N.translateString(entityType)));
        }
        this.filterCriteria.add(new EntityManagerFilterCriteria("Type", "entityType", 2, 3, items, false));
    }

    @Override
    protected String getBaseName() {
        return PerformanceCollectionGenericTask.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("PerformanceViewer");
    }

    public static String formatCreationDate(String creationDate) {
        Date created = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S");
        created = df.parse(creationDate, new ParsePosition(0));
        SimpleDateFormat formater = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        return formater.format((Object)created);
    }

    @Override
    public String getHelpTopic() {
        return "ngnms.help.pm_collection_session_manager";
    }

    @Override
    public ManagerFilterView getFilterView() {
        String adittionalFilter = " tbl1.storage=1";
        return new EntityManagerFilterView(this.getManagerName(), this.getBaseName(), this.getFilterCriteria(), this.getEntityRowProvider(), adittionalFilter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PerformanceViewerRowProvider
    extends EntityManagerRowProviderBase {
        public PerformanceViewerRowProvider(List<String> attributes) {
            super(attributes);
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            ret.set(1, ddI18N.translateString(ret.get(1)));
            ret.set(2, PerformanceViewerManagerConfig.formatCreationDate(ret.get(2)));
            ret.set(3, String.valueOf(Integer.parseInt(ret.get(3))));
            ret.set(4, Task.getStateString(Integer.parseInt(ret.get(4))));
            return ret;
        }

        @Override
        protected String readEntityId(Serializable entity) {
            return String.valueOf(((PerformanceCollectionGenericTask)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PerformanceViewerManagerAction
    extends ManagerAction {
        public PerformanceViewerManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        @Override
        public void performAction(ManagerView manager) {
            List<Serializable> selection = manager.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            PerformanceCollectionGenericTask task = (PerformanceCollectionGenericTask)selection.get(0);
            task = (PerformanceCollectionGenericTask)ServiceRegistry.getTaskManagerService().retrieveTask(task.getId());
            if ("Graph".equals(this.name)) {
                PerformanceCollectionGraphView view = new PerformanceCollectionGraphView(task);
                FrameUtil.runFrame(FrameUtil.createFrame(), task.getName(), view, 800, 600, true);
            } else if ("Export".equals(this.name)) {
                PerformanceCollectionExportView view = new PerformanceCollectionExportView(task);
                FrameUtil.runFrame(FrameUtil.createFrame(), i18n.translateString("ExportPMCollectionData") + " " + task.getName(), view, 800, 600, true);
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (1 == selectionSize) {
                PerformanceCollectionGenericTask task = (PerformanceCollectionGenericTask)selection.get(0);
                return 0 != task.getLastRunResult() || 0L != task.getLastRun();
            }
            return false;
        }

        @Override
        public Internationalizer getI18n() {
            return i18n;
        }
    }
}

