/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.performance.PerformanceCollectionTaskHandler;
import com.bwanms.performance.viewer.CounterSelectorTreeView3;
import com.bwanms.performance.viewer.MultiGraphDataDisplayView;
import com.bwanms.performance.viewer.PerformanceCollectionDataFormHelper;
import com.bwanms.performance.viewer.PerformanceCollectionGraphPanel;
import com.bwanms.services.ServiceRegistry;
import com.ngnms.apps.pmcollection.IAvPMCounterProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PerformanceCollectionGraphView
implements View {
    private static Logger logger = Logger.getLogger(PerformanceCollectionGraphView.class);
    private static Internationalizer i18n = Internationalizer.getInternationalizer(PerformanceCollectionGraphView.class);
    private static Internationalizer ddI18N = Internationalizer.getInternationalizer("com.bwanms.performance.perfTaskTranslation");
    private PerformanceCollectionGraphPanel form;
    private PerformanceCollectionDataFormHelper formHelper;
    private CounterSelectorTreeView3 counterSelectorView;
    private MultiGraphDataDisplayView dataDisplayView;
    private PerformanceCollectionGenericTask task;

    public PerformanceCollectionGraphView(PerformanceCollectionGenericTask performanceTask) {
        this.task = performanceTask;
        PerformanceCollectionTaskHandler taskHandler = PMCollectionEntityTypeUtil.createTaskHandler(this.task.getEntityType());
        String taskIdStr = String.valueOf(this.task.getId());
        this.counterSelectorView = new CounterSelectorTreeView3(taskHandler.getCounterInternationalizer(), false);
        this.dataDisplayView = new MultiGraphDataDisplayView();
        this.formHelper = new PerformanceCollectionDataFormHelper(this.counterSelectorView, this.dataDisplayView, taskIdStr);
        this.initUI();
    }

    private void initUI() {
        this.form = new PerformanceCollectionGraphPanel();
        this.form.getTxtTaskName().setText(this.task.getName());
        this.form.getTxtTaskType().setText(ddI18N.translateString(this.task.getEntityType()));
        this.form.getDateChooserStart().setDate(new Date(System.currentTimeMillis() - 12345678L));
        this.form.getDateChooserEnd().setDate(new Date(System.currentTimeMillis() - 12345678L));
        this.form.getDateChooserStart().setDate(null != this.task.getCreatedDate() ? this.task.getCreatedDate() : new Date());
        this.form.getDateChooserEnd().setDate(new Date());
        this.form.getCheckBoxEndTimeNow().setSelected(true);
        this.form.getSplitPaneCountersGraph().setLeftComponent(this.counterSelectorView.getUI());
        this.form.getSplitPaneCountersGraph().setRightComponent(this.dataDisplayView.getUI());
        this.dataDisplayView.setDisplayEntityLabels(true);
        String entityType = this.task.getEntityType();
        String productLine = PMCollectionEntityTypeUtil.getTaskProductLineByType(entityType);
        PerformanceCollectionTaskCounterProvider counterProvider = new PerformanceCollectionTaskCounterProvider(String.valueOf(this.task.getId()), entityType, productLine);
        for (PerformanceCollectionEntity collEntity : this.task.getEntities()) {
            if (null == collEntity.getEntity()) continue;
            counterProvider.setEntityLabel(String.valueOf(collEntity.getId()), collEntity.getEntityName());
            this.formHelper.addEntity(String.valueOf(collEntity.getId()), String.valueOf(collEntity.getEntityId()), counterProvider, "PMCollectionCategories");
        }
        this.form.getCheckBoxEndTimeNow().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PerformanceCollectionGraphView.this.checkBoxEndTimeNowActionPerformed();
            }
        });
        this.form.getBtnSetGraphTime().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PerformanceCollectionGraphView.this.btnSetGraphTimeActionPerformed();
            }
        });
        this.form.getBtnBuildGraph().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PerformanceCollectionGraphView.this.btnBuildGraphActionPerformed();
            }
        });
        this.checkBoxEndTimeNowActionPerformed();
        this.btnSetGraphTimeActionPerformed();
    }

    public JComponent getUI() {
        return this.form;
    }

    public boolean close() {
        return false;
    }

    public void cleanup() {
        this.counterSelectorView.cleanup();
        this.dataDisplayView.cleanup();
        this.formHelper.unregisterFormListener();
        this.formHelper.cleanup();
        this.counterSelectorView = null;
        this.dataDisplayView = null;
        this.formHelper = null;
        System.gc();
    }

    public String getTitle() {
        return null;
    }

    private void checkBoxEndTimeNowActionPerformed() {
        this.form.getDateChooserEnd().getSpinner().setEnabled(!this.form.getCheckBoxEndTimeNow().isSelected());
    }

    private void btnSetGraphTimeActionPerformed() {
        long endTime;
        long startTime = this.form.getDateChooserStart().getDate().getTime();
        long l = endTime = this.form.getCheckBoxEndTimeNow().isSelected() ? System.currentTimeMillis() : this.form.getDateChooserEnd().getDate().getTime();
        if (endTime != -1L && endTime < startTime) {
            JOptionPane.showMessageDialog(this.form, i18n.translateString("StartTimeAfterEndTime"), i18n.translateString("Error"), 0);
            return;
        }
        this.dataDisplayView.setDisplayRange(startTime, endTime);
    }

    private void btnBuildGraphActionPerformed() {
        try {
            long endTime;
            long startTime = this.form.getDateChooserStart().getDate().getTime();
            long l = endTime = this.form.getCheckBoxEndTimeNow().isSelected() ? System.currentTimeMillis() : this.form.getDateChooserEnd().getDate().getTime();
            if (endTime != -1L && endTime < startTime) {
                JOptionPane.showMessageDialog(this.form, i18n.translateString("StartTimeAfterEndTime"), i18n.translateString("Error"), 0);
                return;
            }
            this.formHelper.setStartTime(startTime);
            this.formHelper.setEndTime(endTime);
            this.formHelper.buildGraph();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.form, i18n.translateString("CouldNotSendRequestForData"), i18n.translateString("Error"), 0);
            e.printStackTrace();
        }
    }

    private class PerformanceCollectionTaskCounterProvider
    implements IAvPMCounterProvider {
        private String sessionName;
        private String entityType;
        private String productLine;
        private Properties entityLabels = new Properties();
        private boolean fetchAllCounters = true;

        public PerformanceCollectionTaskCounterProvider(String pSessionName, String pEntityType, String pProductLine) {
            this.sessionName = pSessionName;
            this.entityType = pEntityType;
            this.productLine = pProductLine;
        }

        public Object getCounters(String pEntityId, String pRootNode, int pDepth) {
            if (this.fetchAllCounters) {
                try {
                    return ServiceRegistry.getPerformanceCollectionViewerService().getCounters(Long.parseLong(this.sessionName), pEntityId, this.entityType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                logger.debug((Object)"RETURN ALL COUNTERS");
                Vector<String[]> ret = new Vector<String[]>();
                ret.add(new String[]{"{all}", ""});
                return ret;
            }
            return null;
        }

        public String getProductLine(String pEntityOID) {
            return this.productLine;
        }

        public void setEntityLabel(String pEntityID, String pLabel) {
            this.entityLabels.setProperty(pEntityID, pLabel);
        }

        public String getEntityLabel(String pEntityID) {
            return this.entityLabels.getProperty(pEntityID, pEntityID);
        }

        public boolean isFetchAllCounters() {
            return this.fetchAllCounters;
        }

        public void setFetchAllCounters(boolean fetchAllCounters) {
            this.fetchAllCounters = fetchAllCounters;
        }
    }
}

