/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.performance.PMCollectionEntityTypeUtil;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.performance.PerformanceCollectionTaskHandler;
import com.bwanms.performance.viewer.EntitySelectorTreeView;
import com.bwanms.performance.viewer.ExportDataDisplayView;
import com.bwanms.performance.viewer.PerformanceCollectionDataFormHelper;
import com.bwanms.performance.viewer.PerformanceCollectionExportPanel;
import com.bwanms.util.MessageBox;
import com.ngnms.apps.pmcollection.IAvPMCounterProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;

public class PerformanceCollectionExportView
implements View {
    private static final Internationalizer ddI18N = Internationalizer.getInternationalizer("com.bwanms.performance.perfTaskTranslation");
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(PerformanceCollectionExportView.class);
    private PerformanceCollectionExportPanel form;
    private EntitySelectorTreeView entitySelectorView;
    private ExportDataDisplayView dataDisplayView;
    private PerformanceCollectionDataFormHelper formHelper;
    private PerformanceCollectionGenericTask task;

    public PerformanceCollectionExportView(PerformanceCollectionGenericTask task) {
        this.task = task;
        PerformanceCollectionTaskHandler taskHandler = PMCollectionEntityTypeUtil.createTaskHandler(task.getEntityType());
        String taskIdStr = String.valueOf(task.getId());
        this.entitySelectorView = new EntitySelectorTreeView(taskHandler.getCounterInternationalizer());
        this.dataDisplayView = new ExportDataDisplayView(taskHandler.getCounterInternationalizer());
        this.formHelper = new PerformanceCollectionDataFormHelper(this.entitySelectorView, this.dataDisplayView, taskIdStr);
        this.formHelper.setSelectAllCounters(true);
        this.initForm();
    }

    private void initForm() {
        this.form = new PerformanceCollectionExportPanel();
        this.form.getTxtTaskName().setText(this.task.getName());
        this.form.getTxtTaskType().setText(ddI18N.translateString(this.task.getEntityType()));
        this.form.getDateChooserStart().setDate(new Date(System.currentTimeMillis() - 12345678L));
        this.form.getDateChooserEnd().setDate(new Date(System.currentTimeMillis() - 12345678L));
        this.form.getDateChooserStart().setDate(null != this.task.getCreatedDate() ? this.task.getCreatedDate() : new Date());
        this.form.getDateChooserEnd().setDate(new Date());
        this.form.getCheckBoxEndTimeNow().setSelected(true);
        this.form.getSplitPaneCountersGraph().setLeftComponent(this.entitySelectorView.getUI());
        this.form.getSplitPaneCountersGraph().setRightComponent(this.dataDisplayView.getUI());
        String entityType = this.task.getEntityType();
        String productLine = PMCollectionEntityTypeUtil.getTaskProductLineByType(entityType);
        ExportTaskCounterProvider counterProvider = new ExportTaskCounterProvider(String.valueOf(this.task.getId()), entityType, productLine);
        for (PerformanceCollectionEntity collEntity : this.task.getEntities()) {
            if (null == collEntity.getEntity()) continue;
            counterProvider.setEntityLabel(String.valueOf(collEntity.getId()), collEntity.getEntityName());
            this.formHelper.addEntity(String.valueOf(collEntity.getId()), String.valueOf(collEntity.getEntityId()), counterProvider, "PMCollectionCategories");
            this.dataDisplayView.setExportEntityInfo(String.valueOf(collEntity.getId()), collEntity.getId() + "." + collEntity.getEntityFileName(), collEntity.getEntityAdditionalHeaderColumns());
        }
        this.form.getCheckBoxEndTimeNow().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PerformanceCollectionExportView.this.checkBoxEndTimeNowActionPerformed();
            }
        });
        this.form.getBtnExportData().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PerformanceCollectionExportView.this.btnExportDataActionPerformed();
            }
        });
        this.checkBoxEndTimeNowActionPerformed();
    }

    public JComponent getUI() {
        return this.form;
    }

    public boolean close() {
        return this.entitySelectorView.close() && this.dataDisplayView.close();
    }

    public void cleanup() {
        this.entitySelectorView.cleanup();
        this.dataDisplayView.cleanup();
        this.formHelper.unregisterFormListener();
        this.formHelper.cleanup();
    }

    public String getTitle() {
        return null;
    }

    private void checkBoxEndTimeNowActionPerformed() {
        this.form.getDateChooserEnd().getSpinner().setEnabled(!this.form.getCheckBoxEndTimeNow().isSelected());
    }

    private void btnExportDataActionPerformed() {
        try {
            long endTime;
            this.dataDisplayView.setStatus("", null);
            if (!this.formHelper.hasSelectedCounters()) {
                MessageBox.WarnConfirm.quickShow(null, i18n.translateString("NoEntitiesSelected"));
                return;
            }
            if (!this.dataDisplayView.isReadyToExport()) {
                return;
            }
            long startTime = this.form.getDateChooserStart().getDate().getTime();
            long l = endTime = this.form.getCheckBoxEndTimeNow().isSelected() ? System.currentTimeMillis() : this.form.getDateChooserEnd().getDate().getTime();
            if (endTime != -1L && endTime < startTime) {
                MessageBox.Error.quickShow(this.form, i18n.translateString("StartTimeAfterEndTime"));
                return;
            }
            this.formHelper.setStartTime(startTime);
            this.formHelper.setEndTime(endTime);
            this.formHelper.buildGraph();
        }
        catch (Exception e) {
            MessageBox.Error.quickShow(this.form, i18n.translateString("CouldNotSendRequestForData"));
            return;
        }
    }

    private class ExportTaskCounterProvider
    implements IAvPMCounterProvider {
        private String productLine;
        private Properties entityLabels = new Properties();

        public ExportTaskCounterProvider(String pSessionName, String pEntityType, String pProductLine) {
            this.productLine = pProductLine;
        }

        public Object getCounters(String pEntityId, String pRootNode, int pDepth) {
            Vector<String[]> ret = new Vector<String[]>();
            ret.add(new String[]{"{all}", ""});
            return ret;
        }

        public String getProductLine(String pEntityOID) {
            return this.productLine;
        }

        public void setEntityLabel(String pEntityID, String pLabel) {
            this.entityLabels.setProperty(pEntityID, pLabel);
        }

        public String getEntityLabel(String pEntityID) {
            return this.entityLabels.getProperty(pEntityID, pEntityID);
        }
    }
}

