/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.services.PerformanceCollectionViewerResponse;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.platform.UIBackgroundJob;
import com.bwanms.util.MessageBox;
import com.ngnms.apps.pmcollection.AvFormGetPmDataResponseEvent;
import com.ngnms.apps.pmcollection.AvFormGetPmDataRuleParamSet;
import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.apps.pmcollection.IAvGPMCounterDefinition;
import com.ngnms.apps.pmcollection.IAvGPMCounterSelector;
import com.ngnms.apps.pmcollection.IAvGPMDataDisplay;
import com.ngnms.apps.pmcollection.IAvPMCounterProvider;
import com.ngnms.apps.pmcollection.IAvPMCounterSelectorListener;
import com.ngnms.apps.pmcollection.IAvPmCollectionDataFormHelperListener;
import com.ngnms.common.AvServerToFormEvent;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceCollectionDataFormHelper
implements IAvPMCounterSelectorListener {
    private static final Logger logger = Logger.getLogger(PerformanceCollectionDataFormHelper.class);
    IAvGPMDataDisplay dataDisplay;
    IAvGPMCounterSelector counterSelector;
    private String formID;
    private String sessionName;
    private Hashtable<String, Vector> selectedCounters = new Hashtable();
    private HashSet<String> selectedCounterIDs = new HashSet();
    private Hashtable<String, String> counterPMIDs = new Hashtable();
    private Hashtable<String, String> targetNEKeys = new Hashtable();
    private Hashtable<String, String> entityIDsByKey = new Hashtable();
    private Vector<String> requestedEntities = new Vector();
    private Vector<IAvPmCollectionDataFormHelperListener> listeners = new Vector();
    private IAvPMCounterProvider counterProvider = null;
    private AvServerToFormEvent serverToFormEvent;
    private long startTime = -1L;
    private long endTime = -1L;
    private boolean selectAllCounters = false;

    public PerformanceCollectionDataFormHelper(IAvGPMCounterSelector pCounterSelector, IAvGPMDataDisplay pDataDisplay, String pSessionName) {
        this.counterSelector = pCounterSelector;
        this.counterSelector.addPMCounterSelectorListener((IAvPMCounterSelectorListener)this);
        this.dataDisplay = pDataDisplay;
        this.sessionName = pSessionName;
    }

    public void addEntity(String pEntityID, String pTargetNEKey, IAvPMCounterProvider pProvider, String pRoot) {
        logger.debug((Object)("PMHELPER - addEntity: " + pEntityID + "  pTargetNEKey: " + pTargetNEKey + " pRoot: " + pRoot));
        this.counterSelector.addEntity(pEntityID, pProvider, pRoot);
        this.targetNEKeys.put(pEntityID, pTargetNEKey);
        this.entityIDsByKey.put(pTargetNEKey, pEntityID);
        if (null == this.counterProvider) {
            this.counterProvider = pProvider;
        }
    }

    public synchronized void counterChanged(IAvGPMCounterDefinition pCounterDef) {
        logger.debug((Object)("counterChanged: " + pCounterDef));
        String counterID = pCounterDef.getCounterID();
        if (this.selectedCounterIDs.contains(counterID)) {
            this.dataDisplay.updateCounter(pCounterDef);
        }
    }

    public synchronized boolean hasSelectedCounters() {
        return !this.selectedCounters.isEmpty();
    }

    public synchronized void counterSelected(IAvGPMCounterDefinition pCounterDef) {
        String entityID = pCounterDef.getEntityID();
        String counterID = pCounterDef.getCounterID();
        String counterName = pCounterDef.getName();
        String counterPMID = entityID + "/" + counterName;
        if (this.selectAllCounters && !"{all}".equals(counterName)) {
            return;
        }
        logger.debug((Object)("counterSelected: " + pCounterDef));
        Vector<String> deviceCounters = this.selectedCounters.get(entityID);
        if (deviceCounters == null) {
            deviceCounters = new Vector<String>();
            this.selectedCounters.put(entityID, deviceCounters);
        }
        this.counterPMIDs.put(counterPMID, counterID);
        if (!this.selectedCounterIDs.contains(counterID)) {
            this.selectedCounterIDs.add(counterID);
            deviceCounters.add(counterName);
            this.dataDisplay.addCounter(pCounterDef);
        }
        this.counterChanged(pCounterDef);
    }

    public synchronized void counterDeselected(IAvGPMCounterDefinition pCounterDef) {
        String entityID = pCounterDef.getEntityID();
        String counterID = pCounterDef.getCounterID();
        String counterName = pCounterDef.getName();
        String counterPMID = entityID + "/" + counterName;
        if (this.selectAllCounters && !"{all}".equals(counterName)) {
            return;
        }
        logger.debug((Object)("counterDeselected: " + pCounterDef));
        Vector deviceCounters = this.selectedCounters.get(entityID);
        if (deviceCounters != null && deviceCounters.remove(counterName)) {
            if (deviceCounters.isEmpty()) {
                this.selectedCounters.remove(entityID);
            }
            this.counterPMIDs.remove(counterPMID);
            this.selectedCounterIDs.remove(counterID);
            this.dataDisplay.setCounterVisible(counterID, false);
        }
    }

    private synchronized void getEntitiesDataOld(Hashtable request) throws Exception {
        if (request == null || request.isEmpty()) {
            return;
        }
        this.requestedEntities.clear();
        Hashtable convRequest = new Hashtable();
        for (String entityID : request.keySet()) {
            this.requestedEntities.add(entityID);
            String targetNEKey = this.targetNEKeys.get(entityID);
            convRequest.put(targetNEKey, request.get(entityID));
        }
        AvFormGetPmDataRuleParamSet event = new AvFormGetPmDataRuleParamSet();
        event.setSessionName(this.sessionName);
        event.setCollVars(convRequest);
        event.setStartTime(this.startTime);
        event.setEndTime(this.endTime == -1L ? System.currentTimeMillis() : this.endTime);
        event.setFormID(this.formID);
        logger.debug((Object)("gettingPMData: " + event));
        event.emit();
        this.dataDisplay.setBusy(true);
        this.fireSetBusy(true);
    }

    private synchronized void getEntitiesData(Hashtable request) throws Exception {
        if (request == null || request.isEmpty()) {
            return;
        }
        this.requestedEntities.clear();
        final Hashtable convRequest = new Hashtable();
        for (String entityID : request.keySet()) {
            this.requestedEntities.add(entityID);
            String targetNEKey = this.targetNEKeys.get(entityID);
            convRequest.put(targetNEKey, request.get(entityID));
        }
        new UIBackgroundJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    PerformanceCollectionDataFormHelper.this.dataDisplay.setBusy(true);
                    PerformanceCollectionDataFormHelper.this.fireSetBusy(true);
                    List<PerformanceCollectionViewerResponse> pmResponses = ServiceRegistry.getPerformanceCollectionViewerService().retrieveData(Long.parseLong(PerformanceCollectionDataFormHelper.this.sessionName), convRequest, PerformanceCollectionDataFormHelper.this.startTime, PerformanceCollectionDataFormHelper.this.endTime == -1L ? System.currentTimeMillis() : PerformanceCollectionDataFormHelper.this.endTime);
                    for (PerformanceCollectionViewerResponse pmResponse : pmResponses) {
                        PerformanceCollectionDataFormHelper.this.processDataEvent(pmResponse.getCollectionVariables(), pmResponse.getCollectionInterval() * 1000L);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                    MessageBox.Error.quickShow("Error occured. Please refresh");
                }
                finally {
                    PerformanceCollectionDataFormHelper.this.dataDisplay.setBusy(false);
                    PerformanceCollectionDataFormHelper.this.fireSetBusy(false);
                }
            }
        }.schedule();
    }

    public synchronized void processDataEvent(Hashtable<String, Hashtable<String, Object[]>> collValues, long collectionInterval) {
        logger.debug((Object)("CollectionInterval: " + collectionInterval));
        for (String targetNEKey : collValues.keySet()) {
            String entityID = this.entityIDsByKey.get(targetNEKey);
            this.requestedEntities.remove(entityID);
            logger.debug((Object)("Got response entity: " + entityID));
            Hashtable<String, Object[]> values = collValues.get(targetNEKey);
            for (String varName : values.keySet()) {
                String counterID;
                Object[] data = values.get(varName);
                String counterPMID = entityID + "/" + varName;
                String string = counterID = this.selectAllCounters ? counterPMID : this.counterPMIDs.get(counterPMID);
                if (null != counterID) {
                    long[] times = (long[])data[0];
                    double[] vals = (double[])data[1];
                    Vector<Long> timesVector = new Vector<Long>();
                    Vector<Double> valsVector = new Vector<Double>();
                    long lastTime = -1L;
                    for (int k = 0; k < vals.length; ++k) {
                        if (lastTime != -1L && times[k] - lastTime > 2L * collectionInterval) {
                            long holeTime = lastTime + collectionInterval;
                            logger.debug((Object)("Inserting hole at: " + holeTime));
                            timesVector.add(new Long(holeTime));
                            valsVector.add(new Double(Double.NaN));
                        }
                        timesVector.add(new Long(times[k]));
                        valsVector.add(new Double(vals[k]));
                        lastTime = times[k];
                    }
                    long[] finalTimes = new long[timesVector.size()];
                    Number[] finalVals = new Double[timesVector.size()];
                    for (int k = 0; k < finalTimes.length; ++k) {
                        finalTimes[k] = (Long)timesVector.elementAt(k);
                    }
                    valsVector.toArray(finalVals);
                    logger.debug((Object)("Setting " + counterID + " " + finalTimes.length + " values"));
                    if (this.selectAllCounters) {
                        this.dataDisplay.removeCounter(counterID);
                        IAvGPMCounterDefinition counterDef = this.createDataResponseCounter(entityID, counterID.substring(counterID.indexOf(47)));
                        counterID = counterDef.getCounterID();
                        this.dataDisplay.addCounter(counterDef);
                    }
                    this.dataDisplay.setCounterValues(counterID, finalTimes, finalVals);
                    continue;
                }
                logger.debug((Object)("Not selected anymore: " + counterID));
            }
        }
        if (this.requestedEntities.isEmpty()) {
            this.dataDisplay.setBusy(false);
            this.fireSetBusy(false);
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public synchronized void buildGraph() throws Exception {
        this.getEntitiesData(this.selectedCounters);
    }

    public synchronized void processDataEvent(AvFormGetPmDataResponseEvent pEvent) {
        Hashtable collValues = pEvent.getCollValues();
        long collectionInterval = (long)pEvent.getTimeInterval() * 1000L;
        logger.debug((Object)("CollectionInterval: " + collectionInterval));
        for (String targetNEKey : collValues.keySet()) {
            String entityID = this.entityIDsByKey.get(targetNEKey);
            this.requestedEntities.remove(entityID);
            logger.debug((Object)("Got response entity: " + entityID));
            Hashtable values = (Hashtable)collValues.get(targetNEKey);
            for (String varName : values.keySet()) {
                String counterID;
                Object[] data = (Object[])values.get(varName);
                String counterPMID = entityID + "/" + varName;
                String string = counterID = this.selectAllCounters ? counterPMID : this.counterPMIDs.get(counterPMID);
                if (null != counterID) {
                    long[] times = (long[])data[0];
                    double[] vals = (double[])data[1];
                    Vector<Long> timesVector = new Vector<Long>();
                    Vector<Double> valsVector = new Vector<Double>();
                    long lastTime = -1L;
                    for (int k = 0; k < vals.length; ++k) {
                        if (lastTime != -1L && times[k] - lastTime > 2L * collectionInterval) {
                            long holeTime = lastTime + collectionInterval;
                            logger.debug((Object)("Inserting hole at: " + holeTime));
                            timesVector.add(new Long(holeTime));
                            valsVector.add(new Double(Double.NaN));
                        }
                        timesVector.add(new Long(times[k]));
                        valsVector.add(new Double(vals[k]));
                        lastTime = times[k];
                    }
                    long[] finalTimes = new long[timesVector.size()];
                    Number[] finalVals = new Double[timesVector.size()];
                    for (int k = 0; k < finalTimes.length; ++k) {
                        finalTimes[k] = (Long)timesVector.elementAt(k);
                    }
                    valsVector.toArray(finalVals);
                    logger.debug((Object)("Setting " + counterID + " " + finalTimes.length + " values"));
                    if (this.selectAllCounters) {
                        this.dataDisplay.removeCounter(counterID);
                        IAvGPMCounterDefinition counterDef = this.createDataResponseCounter(entityID, counterID.substring(counterID.indexOf(47)));
                        counterID = counterDef.getCounterID();
                        this.dataDisplay.addCounter(counterDef);
                    }
                    this.dataDisplay.setCounterValues(counterID, finalTimes, finalVals);
                    continue;
                }
                logger.debug((Object)("Not selected anymore: " + counterID));
            }
        }
        if (this.requestedEntities.isEmpty()) {
            this.dataDisplay.setBusy(false);
            this.fireSetBusy(false);
        }
    }

    private IAvGPMCounterDefinition createDataResponseCounter(String pEntityID, String pCounterID) {
        String label = pCounterID.substring(pCounterID.indexOf(":") + 1);
        AvPMCounterNode counterDef = new AvPMCounterNode(null, pEntityID, pCounterID, label);
        if (null != this.counterProvider) {
            counterDef.setEntityLabel(this.counterProvider.getEntityLabel(pEntityID));
        }
        return counterDef;
    }

    private void fireSetBusy(boolean pBusy) {
        Iterator<IAvPmCollectionDataFormHelperListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().setBusy(pBusy);
        }
    }

    public void addDataFormHelperListener(IAvPmCollectionDataFormHelperListener pListener) {
        this.listeners.add(pListener);
    }

    public void removeDataFormHelperListener(IAvPmCollectionDataFormHelperListener pListener) {
        this.listeners.remove(pListener);
    }

    public void setSelectAllCounters(boolean pSelectAllCounters) {
        this.selectAllCounters = pSelectAllCounters;
    }

    public void registerFormListener() {
    }

    public void unregisterFormListener() {
    }

    public void cleanup() {
        this.counterSelector.removePMCounterSelectorListener((IAvPMCounterSelectorListener)this);
    }
}

