/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.performance.viewer.MultiGraphDataDisplayPanel;
import com.bwanms.util.PrinterUtil;
import com.dorado.common.widget.components.interfaces.IOWGButton;
import com.dorado.common.widget.components.interfaces.IOWGDataWidget;
import com.ngnms.apps.pmcollection.AvMultiCounterGraph;
import com.ngnms.apps.pmcollection.AvMultiGraphStyle;
import com.ngnms.apps.pmcollection.IAvCounterGraphListener;
import com.ngnms.apps.pmcollection.IAvGPMCounterDefinition;
import com.ngnms.apps.pmcollection.IAvGPMDataDisplay;
import com.ngnms.apps.pmcollection.IAvPMDataDisplayListener;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class MultiGraphDataDisplayView
implements View,
IAvGPMDataDisplay,
IAvCounterGraphListener {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(MultiGraphDataDisplayView.class);
    private MultiGraphDataDisplayPanel form;
    private AvMultiCounterGraph graph;
    private JFileChooser rcFileChooser = new JFileChooser();
    private Vector<IAvPMDataDisplayListener> pmDataDisplayListeners = new Vector();
    private Object rcPrint = null;
    private Hashtable<String, IAvGPMCounterDefinition> counters = new Hashtable();
    private boolean displayEntityLabels = false;
    private String graphTitle = "";
    private String style = AvMultiGraphStyle.getDefaultStyle();
    IOWGButton btnSave;
    IOWGDataWidget printMenu;

    public MultiGraphDataDisplayView() {
        this.initUI();
    }

    private void initUI() {
        this.form = new MultiGraphDataDisplayPanel();
        this.graph = this.form.getMultiCounterGraph();
        this.graph.addListener((IAvCounterGraphListener)this);
        this.initComponents();
        this.actionTogglePanZoom();
        this.form.getToggleButtonPanZoom().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiGraphDataDisplayView.this.actionTogglePanZoom();
            }
        });
        this.form.getCheckBoxPositiveOnly().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiGraphDataDisplayView.this.actionPositiveOnly();
            }
        });
        this.form.getChkShowLegend().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiGraphDataDisplayView.this.actionLegendVisible();
            }
        });
        this.form.getMenuItemPrint().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiGraphDataDisplayView.this.printChart();
            }
        });
        this.form.getMenuItemPrintPreview().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiGraphDataDisplayView.this.printPreview();
            }
        });
        this.form.getMenuItemPageSetup().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiGraphDataDisplayView.this.pageSetup();
            }
        });
    }

    public void actionPositiveOnly() {
        this.graph.setPositiveOnly(this.form.getCheckBoxPositiveOnly().isSelected());
    }

    public void actionLegendVisible() {
        if (this.form.getChkShowLegend().isSelected()) {
            this.graph.getLegend().show();
        } else {
            this.graph.getLegend().hide();
        }
    }

    public void actionSave() {
        String saveFile = null;
        int _option = this.rcFileChooser.showDialog(this.form, "Select");
        if (_option == 0) {
            saveFile = this.rcFileChooser.getSelectedFile().getAbsolutePath();
        }
        if (saveFile == null || saveFile.length() == 0) {
            return;
        }
        if (saveFile.length() < 4 || !saveFile.substring(saveFile.length() - 4).equalsIgnoreCase(".jpg")) {
            saveFile = saveFile + ".jpg";
        }
        Dimension graphSize = this.graph.getSize();
        BufferedImage buffImage = new BufferedImage(graphSize.width, graphSize.height, 1);
        this.graph.paint(buffImage.getGraphics());
        try {
            FileOutputStream output = new FileOutputStream(saveFile);
            JPEGEncodeParam encoderParams = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)buffImage);
            encoderParams.setQuality(0.9f, true);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)output, (JPEGEncodeParam)encoderParams);
            encoder.encode(buffImage);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void actionTogglePanZoom() {
        if (this.form.getToggleButtonPanZoom().isSelected()) {
            this.form.getToggleButtonPanZoom().setText(i18n.translateString("Zoom"));
            this.graph.setInteractionMode(2);
        } else {
            this.form.getToggleButtonPanZoom().setText(i18n.translateString("Pan"));
            this.graph.setInteractionMode(1);
        }
    }

    public void addCounter(IAvGPMCounterDefinition pCounterDef) {
        this.counters.put(pCounterDef.getCounterID(), pCounterDef);
        this.graph.addSeries(pCounterDef.getCounterID(), this.displayEntityLabels ? pCounterDef.getEntityLabel() + " - " + pCounterDef.getLabel() : pCounterDef.getLabel(), pCounterDef.getStyle(), pCounterDef.getDisplayMode());
    }

    public void addPMDataDisplayListener(IAvPMDataDisplayListener pListener) {
        this.pmDataDisplayListeners.add(pListener);
    }

    public void addValue(String pSeriesId, Number pValue, long pTime) {
        this.graph.addValue(pSeriesId, pValue, pTime);
    }

    public void addValues(String[] pSeriesIds, Number[] pValues, long pTime) {
        this.graph.addValues(pSeriesIds, pValues, pTime);
    }

    public void counterBoundsChanged(String pCounterId, double pMin, double pMax) {
        Iterator<IAvPMDataDisplayListener> i = this.pmDataDisplayListeners.iterator();
        while (i.hasNext()) {
            i.next().counterBoundsChanged(pCounterId, pMin, pMax);
        }
    }

    public boolean getDisplayEntityLabels() {
        return this.displayEntityLabels;
    }

    public String getGraphTitle() {
        return this.graphTitle;
    }

    public String getStyle() {
        return this.style;
    }

    public void initComponents() {
        this.graph.getLegend().setIsShowing(true);
        this.initFileChooser();
    }

    public void initFileChooser() {
        this.rcFileChooser.setFileHidingEnabled(false);
        this.rcFileChooser.setApproveButtonMnemonic('S');
        String dialogTitle = "SpecifyJPEGFileToBeExported";
        String filterDescription = "JPEGFiles";
        this.rcFileChooser.setDialogTitle(dialogTitle);
        this.rcFileChooser.setDialogType(1);
        this.rcFileChooser.setFileSelectionMode(0);
        this.rcFileChooser.setMultiSelectionEnabled(false);
        this.rcFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                String fName = f.getName();
                return f.isDirectory() || fName.length() > 4 && fName.substring(fName.length() - 4).equalsIgnoreCase(".jpg");
            }

            public String getDescription() {
                return "JPEGFiles";
            }
        });
    }

    public void pageSetup() {
        if (this.rcPrint == null) {
            this.rcPrint = new PrinterUtil();
        }
        ((PrinterUtil)this.rcPrint).pageFormat();
    }

    public void printChart() {
        if (this.rcPrint == null) {
            this.rcPrint = new PrinterUtil();
        }
        ((PrinterUtil)this.rcPrint).printComponent((Component)this.graph, this.graphTitle, false);
    }

    public void printPreview() {
        if (this.rcPrint == null) {
            this.rcPrint = new PrinterUtil();
        }
        ((PrinterUtil)this.rcPrint).printComponent((Component)this.graph, "", true);
    }

    public void removeCounter(String pSeriesId) {
        this.graph.removeSeries(pSeriesId);
        this.counters.remove(pSeriesId);
    }

    public void removePMDataDisplayListener(IAvPMDataDisplayListener pListener) {
        this.pmDataDisplayListeners.remove(pListener);
    }

    public void setBusy(boolean pBusy) {
    }

    public void setCounterValues(String pCounterID, long[] pTimes, Number[] pValues) {
        this.graph.setSeriesValues(pCounterID, pTimes, pValues);
    }

    public void setCounterVisible(String pCounterID, boolean pVisible) {
        if (pVisible) {
            this.graph.showSeries(pCounterID);
        } else {
            this.graph.hideSeries(pCounterID);
        }
    }

    public void setDisplayEntityLabels(boolean pDisplayEntityLabels) {
        this.displayEntityLabels = pDisplayEntityLabels;
        for (String counterID : this.counters.keySet()) {
            IAvGPMCounterDefinition counterDef = this.counters.get(counterID);
            if (counterDef == null) continue;
            this.graph.setSeriesLabel(counterID, this.displayEntityLabels ? counterDef.getEntityLabel() + " - " + counterDef.getLabel() : counterDef.getLabel());
        }
    }

    public void setDisplayRange(long pRangeStart, long pRangeEnd) {
        this.graph.setDisplayRange(pRangeStart, pRangeEnd);
    }

    public void setGraphTitle(String pGraphTitle) {
        this.graphTitle = pGraphTitle;
    }

    public void setStyle(String pStyle) {
        this.style = pStyle;
    }

    public void updateCounter(IAvGPMCounterDefinition pCounterDef) {
        String counterID = pCounterDef.getCounterID();
        this.graph.setSeriesLabel(counterID, this.displayEntityLabels ? pCounterDef.getEntityLabel() + " - " + pCounterDef.getLabel() : pCounterDef.getLabel());
        double[] bounds = pCounterDef.getBounds();
        this.graph.setSeriesBounds(counterID, bounds[0], bounds[1]);
        this.graph.setSeriesScale(counterID, pCounterDef.getScale());
        this.graph.setSeriesStyle(counterID, pCounterDef.getStyle());
        this.graph.setSeriesDisplayMode(counterID, pCounterDef.getDisplayMode());
    }

    public JComponent getUI() {
        return this.form;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
        this.graph.removeListener((IAvCounterGraphListener)this);
        this.graph.cleanup();
    }

    public String getTitle() {
        return null;
    }

    public AvMultiCounterGraph getGraph() {
        return this.graph;
    }
}

