/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.bwanms.performance.viewer.ExportDataDisplayPanel;
import com.bwanms.util.MessageBox;
import com.bwanms.util.NameValuePair;
import com.l2fprod.common.swing.JDirectoryChooser;
import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.apps.pmcollection.IAvGPMCounterDefinition;
import com.ngnms.apps.pmcollection.IAvGPMDataDisplay;
import com.ngnms.apps.pmcollection.IAvPMDataDisplayListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ExportDataDisplayView
implements View,
IAvGPMDataDisplay {
    private static Logger logger = Logger.getLogger(ExportDataDisplayView.class);
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(ExportDataDisplayView.class);
    public static final long ROUNDING_OFFSET = 30000L;
    public static final long ROUNDING_INTERVAL = 60000L;
    private ExportDataDisplayPanel form;
    private Map<String, ExportEntityInfo> entityInfos = new Hashtable<String, ExportEntityInfo>();
    private Map<String, IAvGPMCounterDefinition> counters = new Hashtable<String, IAvGPMCounterDefinition>();
    private String currentEntity = null;
    private Map<String, Object[]> currentEntityValues = null;
    private CounterNodeInternationalizer counterInternationalizer;
    private boolean sessionError;

    public ExportDataDisplayView(CounterNodeInternationalizer counterInternationalizer) {
        this.counterInternationalizer = counterInternationalizer;
        this.initForm();
    }

    private void initForm() {
        this.form = new ExportDataDisplayPanel();
        this.form.getBtnBrowse().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExportDataDisplayView.this.actionSelectFile();
            }
        });
    }

    public void actionSelectFile() {
        JDirectoryChooser dirChooser = new JDirectoryChooser();
        String currentPath = this.form.getTxtExportFolder().getText();
        if (null == currentPath) {
            currentPath = "";
        }
        dirChooser.setCurrentDirectory(new File(currentPath));
        dirChooser.setDialogTitle(i18n.translateString("SpecifyCSVFolder"));
        dirChooser.setMultiSelectionEnabled(false);
        dirChooser.setDialogType(1);
        dirChooser.setApproveButtonText(i18n.translateString("Select"));
        dirChooser.setApproveButtonMnemonic('S');
        if (dirChooser.showSaveDialog((Component)this.form) == 0) {
            String exportFolder = dirChooser.getSelectedFile().getAbsolutePath();
            if (null == exportFolder || 0 == exportFolder.length()) {
                this.form.getTxtExportFolder().setText("");
            } else {
                this.form.getTxtExportFolder().setText(exportFolder);
            }
        }
    }

    public void addCounter(IAvGPMCounterDefinition pCounterDef) {
        String counterID = pCounterDef.getCounterID();
        logger.debug((Object)("Adding counter: " + counterID + "  label: " + pCounterDef.getLabel()));
        this.counterInternationalizer.translateNode((AvPMCounterNode)pCounterDef);
        this.counters.put(counterID, pCounterDef);
    }

    public void addStringValue(String pEntityID, String pCounterID, String pValue) {
    }

    public void addValue(String pCounterID, Number pValue, long pTime) {
        this.addValues(new String[]{pCounterID}, new Number[]{pValue}, pTime);
    }

    public void addValues(String[] pCounterIDs, Number[] pValues, long pTime) {
    }

    public void flushCurrentEntity() {
        try {
            logger.debug((Object)("flushCurrentEntity() : " + this.currentEntity));
            int counterCount = this.currentEntityValues.size();
            if (0 == counterCount) {
                logger.debug((Object)("No counters collected for: " + this.currentEntity + ". SKIPPING!"));
                return;
            }
            ExportEntityInfo entityInfo = this.entityInfos.get(this.currentEntity);
            String fileName = this.getEntityFileName(entityInfo.getEntityFileName());
            NameValuePair[] additionalHeaderColumns = entityInfo.getAdditionalHeaderColumns();
            this.setStatus("WritingTo", new String[]{fileName});
            PrintWriter outWriter = new PrintWriter(new FileWriter(fileName));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            int[] positions = new int[counterCount];
            Arrays.fill(positions, 0);
            Object[] times = new Object[counterCount];
            Object[] values = new Object[counterCount];
            logger.debug((Object)("counterCount: " + counterCount));
            int idx = 0;
            int finishedSeries = 0;
            outWriter.print("Timestamp");
            if (null != additionalHeaderColumns) {
                for (NameValuePair nvp : additionalHeaderColumns) {
                    outWriter.print("," + nvp.getName());
                }
            }
            TreeSet<String> sortedHeaders = new TreeSet<String>();
            sortedHeaders.addAll(this.currentEntityValues.keySet());
            for (String counterID : sortedHeaders) {
                IAvGPMCounterDefinition counterDef = this.counters.get(counterID);
                outWriter.print(',');
                outWriter.print(counterDef.getLabel());
                Object[] _vals = this.currentEntityValues.get(counterID);
                times[idx] = _vals[0];
                if (((long[])times[idx]).length == 0) {
                    positions[idx] = -1;
                    ++finishedSeries;
                }
                values[idx] = _vals[1];
                ++idx;
            }
            outWriter.println();
            long lastExportTime = 0L;
            while (finishedSeries < counterCount) {
                if (logger.isDebugEnabled()) {
                    StringBuffer posBuf = new StringBuffer();
                    for (int i = 0; i < counterCount; ++i) {
                        posBuf.append(positions[i]);
                        posBuf.append(' ');
                    }
                    logger.debug((Object)("positions : " + posBuf.toString()));
                }
                double[] currentRow = new double[counterCount];
                byte[] positionAdvance = new byte[counterCount];
                long cTime = 0L;
                for (int i = 0; i < counterCount; ++i) {
                    if (positions[i] == -1) continue;
                    long[] cTimes = (long[])times[i];
                    long roundTime = ExportDataDisplayView.getRoundTime(cTimes[positions[i]]);
                    if (cTime == 0L || roundTime < cTime) {
                        Arrays.fill(currentRow, Double.NaN);
                        Arrays.fill(positionAdvance, (byte)0);
                        positionAdvance[i] = 1;
                        currentRow[i] = ((Number[])values[i])[positions[i]].doubleValue();
                        cTime = roundTime;
                        continue;
                    }
                    if (roundTime != cTime) continue;
                    currentRow[i] = ((Number[])values[i])[positions[i]].doubleValue();
                    positionAdvance[i] = 1;
                }
                StringBuffer line = new StringBuffer();
                line.append(dateFormat.format(new Date(cTime)));
                if (null != additionalHeaderColumns) {
                    for (NameValuePair nvp : additionalHeaderColumns) {
                        line.append(',');
                        line.append(nvp.getValue());
                    }
                }
                boolean allNaNs = true;
                for (int r = 0; r < counterCount; ++r) {
                    line.append(',');
                    if (!Double.isNaN(currentRow[r])) {
                        line.append(Double.toString(currentRow[r]));
                        allNaNs = false;
                    }
                    if (positionAdvance[r] <= 0) continue;
                    long[] cTimes = (long[])times[r];
                    int n = r;
                    positions[n] = positions[n] + positionAdvance[r];
                    if (positions[r] < cTimes.length) continue;
                    positions[r] = -1;
                    ++finishedSeries;
                }
                if (!allNaNs && cTime > lastExportTime) {
                    outWriter.println(line.toString());
                }
                lastExportTime = cTime;
            }
            outWriter.flush();
            outWriter.close();
            logger.debug((Object)("flushCurrentEntity() : " + this.currentEntity + " Done"));
            this.setStatus("", null);
        }
        catch (IOException e) {
            this.sessionError = true;
            logger.error((Object)e, (Throwable)e);
        }
    }

    public String getEntityFileName(String fileName) {
        String fn = this.form.getTxtExportFolder().getText();
        fn = fn + (fn.endsWith(File.separator) ? "" : File.separator);
        fn = fn + fileName + ".csv";
        return fn;
    }

    public static long getRoundTime(long pTime) {
        return (pTime + 30000L) / 60000L * 60000L;
    }

    public boolean isReadyToExport() {
        String selPath = this.form.getTxtExportFolder().getText();
        if (!"".equals(selPath)) {
            File pathFile = new File(selPath);
            if (pathFile.exists() && pathFile.isDirectory()) {
                if (pathFile.list().length > 0) {
                    boolean csvFileExists = false;
                    for (String fileName : pathFile.list()) {
                        if (!fileName.endsWith(".csv")) continue;
                        csvFileExists = true;
                        break;
                    }
                    if (csvFileExists) {
                        return MessageBox.WarnConfirm.showResult(this.form, i18n.translateString("OverwriteExistingCSVFiles"), i18n.translateString("WarningTitle"));
                    }
                    return true;
                }
                return true;
            }
            int createOption = MessageBox.WarnConfirm.showOption(this.form, i18n.translateString("ConfirmCreateNewDir", pathFile.getAbsolutePath()), i18n.translateString("CreateNewDirTitle"));
            if (createOption != 0) {
                return false;
            }
            if (pathFile.mkdirs()) {
                return true;
            }
            MessageBox.Error.showResult(this.form, i18n.translateString("CreateNewDirError", pathFile.getAbsolutePath()), i18n.translateString("CreateNewDirTitle"));
            return false;
        }
        MessageBox.WarnConfirm.showResult(this.form, i18n.translateString("NoExportDirSelected"));
        this.form.getTxtExportFolder().requestFocusInWindow();
        return false;
    }

    public void removeCounter(String pCounterID) {
    }

    public void setBusy(boolean pBusy) {
        if (!pBusy) {
            if (this.currentEntity != null) {
                this.flushCurrentEntity();
                this.currentEntity = null;
                this.currentEntityValues = null;
            }
            this.setStatus(this.sessionError ? "ErrorExportingData" : "ExportedDataSuccessfully", null);
        }
        this.sessionError = false;
        this.form.getBtnBrowse().setEnabled(!pBusy);
    }

    public void setCounterValues(String pCounterID, long[] pTimes, Number[] pValues) {
        IAvGPMCounterDefinition counterDef = this.counters.get(pCounterID);
        String entityID = counterDef.getEntityID();
        if (entityID == null || !entityID.equals(this.currentEntity)) {
            if (null != this.currentEntity) {
                this.flushCurrentEntity();
                this.currentEntity = null;
                this.currentEntityValues = null;
            }
            if (null != entityID) {
                this.setStatus("CollectingDataFor", new String[]{counterDef.getEntityLabel()});
                this.currentEntity = entityID;
                this.currentEntityValues = new Hashtable<String, Object[]>();
                this.currentEntityValues.put(pCounterID, new Object[]{pTimes, pValues});
            }
        } else {
            this.currentEntityValues.put(pCounterID, new Object[]{pTimes, pValues});
        }
    }

    public void setCounterVisible(String pCounterID, boolean pVisible) {
    }

    public void setExportEntityInfo(String entityID, String fileName, NameValuePair[] additionalHeaderColumns) {
        ExportEntityInfo info = new ExportEntityInfo();
        info.setEntityFileName(fileName);
        info.setAdditionalHeaderColumns(additionalHeaderColumns);
        this.entityInfos.put(entityID, info);
    }

    public void setStatus(String pStatusText, String[] pParams) {
        String statusText = pStatusText;
        statusText = null == pParams ? i18n.translateString(pStatusText) : i18n.translateString(pStatusText, pParams);
        this.form.getLblStatus().setText(statusText);
    }

    public void addPMDataDisplayListener(IAvPMDataDisplayListener pListener) {
    }

    public void updateCounter(IAvGPMCounterDefinition pCounterDef) {
    }

    public void removePMDataDisplayListener(IAvPMDataDisplayListener pListener) {
    }

    public JComponent getUI() {
        return this.form;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return null;
    }

    private static class ExportEntityInfo {
        private String entityFileName;
        private NameValuePair[] additionalHeaderColumns;

        private ExportEntityInfo() {
        }

        public String getEntityFileName() {
            return this.entityFileName;
        }

        public void setEntityFileName(String entityFileName) {
            this.entityFileName = entityFileName;
        }

        public NameValuePair[] getAdditionalHeaderColumns() {
            return this.additionalHeaderColumns;
        }

        public void setAdditionalHeaderColumns(NameValuePair[] additionalHeaderColumns) {
            this.additionalHeaderColumns = additionalHeaderColumns;
        }
    }
}

