/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.bwanms.performance.viewer.CounterSelectorSupport;
import com.bwanms.performance.viewer.EntitySelectorTableModel;
import com.bwanms.performance.viewer.EntitySelectorTreePanel;
import com.bwanms.util.TableUtil;
import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.apps.pmcollection.IAvGPMCounterSelector;
import com.ngnms.apps.pmcollection.IAvPMCounterProvider;
import com.ngnms.apps.pmcollection.IAvPMCounterSelectorListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;

public class EntitySelectorTreeView
implements View,
IAvGPMCounterSelector {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(EntitySelectorTreeView.class);
    private EntitySelectorTreePanel form;
    private CounterSelectorSupport selectorSupport = null;
    private EntitySelectorTableModel tableModel = new EntitySelectorTableModel();
    private boolean selectAll = true;

    public EntitySelectorTreeView(CounterNodeInternationalizer counterInternationalizer) {
        this.selectorSupport = new CounterSelectorSupport(counterInternationalizer);
        this.selectorSupport.setAutoLoadNodes(true);
        this.initForm();
    }

    public void initForm() {
        this.form = new EntitySelectorTreePanel();
        this.form.getTreeCounters().setModel(this.tableModel);
        DefaultListSelectionModel selModel = new DefaultListSelectionModel();
        selModel.setSelectionMode(0);
        this.form.getTreeCounters().setSelectionModel(selModel);
        this.form.getBtnSelectAll().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntitySelectorTreeView.this.tableModel.selectAllNodes(EntitySelectorTreeView.this.selectAll);
                EntitySelectorTreeView.this.form.getBtnSelectAll().setText(i18n.translateString(EntitySelectorTreeView.this.selectAll ? "UnselectAll" : "SelectAll"));
                EntitySelectorTreeView.this.selectAll = !EntitySelectorTreeView.this.selectAll;
            }
        });
        TableUtil.autoResizeColumn(this.form.getTreeCounters(), 0, true);
    }

    public void addEntity(String pEntityID, IAvPMCounterProvider pCounterProvider, String pRoot) {
        this.selectorSupport.addEntity(pEntityID, pCounterProvider, pRoot);
        AvPMCounterNode rootNode = this.selectorSupport.getRootNode(pEntityID);
        if (null != rootNode) {
            this.tableModel.addNode(rootNode);
        }
    }

    public void addPMCounterSelectorListener(IAvPMCounterSelectorListener pListener) {
        this.selectorSupport.addPMCounterSelectorListener(pListener);
    }

    public void removeEntity(String pEntityID) {
        this.selectorSupport.removeEntity(pEntityID);
    }

    public void removePMCounterSelectorListener(IAvPMCounterSelectorListener pListener) {
        this.selectorSupport.removePMCounterSelectorListener(pListener);
    }

    public void setCounterValue(String pCounterID, double pValue, boolean pOverflow) {
        this.selectorSupport.setCounterValue(pCounterID, pValue, pOverflow);
    }

    public JComponent getUI() {
        return this.form;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return null;
    }

    public void setCounterValues(String[] pCounterIDs, double[] pValues, boolean[] pOverflow) {
    }
}

