/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.apps.pmcollection.AvPMCounterNodeUtil;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySelectorTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3665366315330290310L;
    private static final String[] COLUMNS = new String[]{" ", "Entity"};
    private ArrayList<AvPMCounterNode> nodes = new ArrayList();

    public void addNode(AvPMCounterNode node) {
        this.nodes.add(node);
        this.fireTableDataChanged();
    }

    public void removeNode(int index) {
        this.nodes.remove(index);
        this.fireTableDataChanged();
    }

    public AvPMCounterNode getNodeAt(int index) {
        return this.nodes.get(index);
    }

    public void insertNode(int index, AvPMCounterNode node) {
        this.nodes.add(index, node);
        this.fireTableDataChanged();
    }

    public void selectAllNodes(boolean selected) {
        for (AvPMCounterNode node : this.nodes) {
            node.setSelected(selected);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.nodes.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMNS[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        throw new AssertionError((Object)"Are we stupid or something?");
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return 0 == columnIndex;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AvPMCounterNode node = this.nodes.get(rowIndex);
        if (columnIndex == 0) {
            return node.isSelected();
        }
        if (columnIndex == 1) {
            StringBuffer label = new StringBuffer();
            for (int i = 0; i < node.getDepth(); ++i) {
                label.append("    ");
            }
            label.append(node.getEntityLabel());
            label.append(" - ");
            label.append(node.getLabel());
            return label.toString();
        }
        throw new AssertionError();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        AvPMCounterNode node = this.nodes.get(rowIndex);
        if (columnIndex == 0) {
            AvPMCounterNodeUtil.setNodesSelected((AvPMCounterNode)node, (boolean)((Boolean)aValue));
        }
    }
}

