/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.gui.View;
import com.bwanms.gui.util.ColorEditor;
import com.bwanms.gui.util.ColorRenderer;
import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.bwanms.performance.viewer.CounterSelectorSupport;
import com.bwanms.performance.viewer.CounterSelectorTreeModel3;
import com.bwanms.performance.viewer.CounterSelectorTreePanel3;
import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.apps.pmcollection.IAvGPMCounterSelector;
import com.ngnms.apps.pmcollection.IAvPMCounterProvider;
import com.ngnms.apps.pmcollection.IAvPMCounterSelectorListener;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class CounterSelectorTreeView3
implements View,
IAvGPMCounterSelector {
    private CounterSelectorTreePanel3 form;
    private CounterSelectorSupport selectorSupport;
    private CounterSelectorTreeModel3 treeModel;
    private boolean withValueColumn;

    public CounterSelectorTreeView3(CounterNodeInternationalizer counterInternationalizer, boolean withValueColumn) {
        this.withValueColumn = withValueColumn;
        this.selectorSupport = new CounterSelectorSupport(counterInternationalizer);
        this.treeModel = new CounterSelectorTreeModel3(this.selectorSupport, withValueColumn);
        this.initForm();
    }

    public void initForm() {
        this.form = new CounterSelectorTreePanel3(this.treeModel);
        ((JLabel)((Object)this.form.getTreeTableCounters().getDefaultRenderer(String.class))).setHorizontalAlignment(4);
        this.form.getTreeTableCounters().getColumnModel().getColumn(0).setPreferredWidth(220);
        this.form.getTreeTableCounters().getColumnModel().getColumn(1).setPreferredWidth(25);
        this.form.getTreeTableCounters().getColumnModel().getColumn(1).setMaxWidth(25);
        this.form.getTreeTableCounters().getColumnModel().getColumn(1).setMinWidth(25);
        this.form.getTreeTableCounters().getColumnModel().getColumn(1).setCellRenderer(new ColorRenderer(true));
        this.form.getTreeTableCounters().getColumnModel().getColumn(1).setCellEditor(new ColorEditor());
        JComboBox<Double> comboScale = new JComboBox<Double>(new Double[]{1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8});
        comboScale.setRenderer(new ComboBoxScaleRenderer());
        DefaultCellEditor dce = new DefaultCellEditor(comboScale);
        dce.setClickCountToStart(2);
        this.form.getTreeTableCounters().getColumnModel().getColumn(this.withValueColumn ? 3 : 2).setCellEditor(dce);
        this.form.getTreeTableCounters().getColumnModel().getColumn(this.withValueColumn ? 3 : 2).setCellRenderer(new CellRendererScale());
    }

    public void addEntity(String pEntityID, IAvPMCounterProvider pCounterProvider, String pRoot) {
        this.selectorSupport.addEntity(pEntityID, pCounterProvider, pRoot);
        AvPMCounterNode rootNode = this.selectorSupport.getRootNode(pEntityID);
        if (null != rootNode) {
            this.treeModel.addRoot(rootNode);
        }
    }

    public void addPMCounterSelectorListener(IAvPMCounterSelectorListener pListener) {
        this.selectorSupport.addPMCounterSelectorListener(pListener);
    }

    public void removeEntity(String pEntityID) {
        AvPMCounterNode root = this.selectorSupport.getRootNode(pEntityID);
        this.selectorSupport.removeEntity(pEntityID);
        if (root != null) {
            this.treeModel.removeRoot(root);
        }
    }

    public void removePMCounterSelectorListener(IAvPMCounterSelectorListener pListener) {
        this.selectorSupport.removePMCounterSelectorListener(pListener);
    }

    public void setCounterValue(String pCounterID, double pValue, boolean pOverflow) {
        this.selectorSupport.setCounterValue(pCounterID, pValue, pOverflow);
    }

    public void setCounterValues(String[] pCounterIDs, double[] pValues, boolean[] pOverflow) {
        this.selectorSupport.setCounterValues(pCounterIDs, pValues, pOverflow);
    }

    public JComponent getUI() {
        return this.form;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return null;
    }

    public void setAutoLoadNodes(boolean autoLoadNodes) {
        this.selectorSupport.setAutoLoadNodes(autoLoadNodes);
    }

    public AvPMCounterNode getRoot(String pEntityID) {
        return this.selectorSupport.getRootNode(pEntityID);
    }

    private class CellRendererScale
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CellRendererScale() {
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setEnabled(table.isEnabled());
            this.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : this.noFocusBorder);
            this.setFont(table.getFont());
            if (value instanceof Double) {
                this.setText(AvPMCounterNode.getScaleString((double)((Double)value)));
            } else {
                this.setText(null);
            }
            return this;
        }
    }

    private class ComboBoxScaleRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -1869607083107747608L;

        public ComboBoxScaleRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(AvPMCounterNode.getScaleString((double)((Double)value)));
            this.setFont(list.getFont());
            return this;
        }
    }
}

