/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.util.AbstractTreeModel;
import com.bwanms.gui.util.treetable.TreeTableModel;
import com.bwanms.performance.viewer.CounterSelectorSupport;
import com.bwanms.util.MessageBox;
import com.ngnms.apps.pmcollection.AvGenericStyle;
import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.apps.pmcollection.AvPMCounterStyle;
import com.ngnms.apps.pmcollection.IAvGPMCounterDefinition;
import com.ngnms.apps.pmcollection.IAvPMCounterSelectorListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CounterSelectorTreeModel3
extends AbstractTreeModel
implements TreeWillExpandListener,
IAvPMCounterSelectorListener,
TreeTableModel {
    private static final Logger logger = Logger.getLogger(CounterSelectorTreeModel3.class);
    private static Internationalizer i18n = Internationalizer.getInternationalizer(CounterSelectorTreeModel3.class);
    private Object root = new Object();
    private ArrayList<AvPMCounterNode> roots = new ArrayList();
    private CounterSelectorSupport selectorSupport;
    private boolean withValueColumn;
    protected static String[] cNames = new String[]{i18n.translateString("Name"), "", i18n.translateString("Value"), i18n.translateString("Scale")};
    protected static Class[] cTypes = new Class[]{TreeTableModel.class, Color.class, String.class, Double.class};

    public CounterSelectorTreeModel3(CounterSelectorSupport selectorSupport, boolean withValueColumn) {
        this.selectorSupport = selectorSupport;
        this.withValueColumn = withValueColumn;
        selectorSupport.addPMCounterSelectorListener(this);
    }

    public void addRoot(AvPMCounterNode counterRoot) {
        this.roots.add(counterRoot);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
    }

    public void removeRoot(AvPMCounterNode counterRoot) {
        if (this.roots.remove(counterRoot)) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.roots.get(index);
        }
        return ((AvPMCounterNode)parent).getChildren().get(index);
    }

    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.roots.size();
        }
        Vector children = ((AvPMCounterNode)parent).getChildren();
        return null != children ? children.size() : 0;
    }

    public boolean isLeaf(Object node) {
        return node != this.root && !((AvPMCounterNode)node).isCategory();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            return this.roots.indexOf(child);
        }
        return ((AvPMCounterNode)parent).getChildren().indexOf(child);
    }

    private Object[] getPath(AvPMCounterNode node) {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(node);
        while (node.getParent() != null) {
            node = node.getParent();
            ret.add(0, node);
        }
        ret.add(0, this.root);
        Object[] retA = new Object[ret.size()];
        return ret.toArray(retA);
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        Object node = event.getPath().getLastPathComponent();
        if (node instanceof AvPMCounterNode) {
            AvPMCounterNode pmNode = (AvPMCounterNode)node;
            if (pmNode.isCategory() && !pmNode.isLoaded()) {
                logger.debug((Object)("Expanding: " + node));
                this.selectorSupport.loadNode(pmNode);
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, event.getPath()));
            }
            if (!(pmNode.getParent() != null || pmNode.isGrayedOut() || pmNode.getChildren() != null && pmNode.getChildren().size() != 0)) {
                MessageBox.Alert.quickShow((JComponent)event.getSource(), i18n.translateString("ThisEntityHasNoCounter"));
                pmNode.setGrayedOut(true);
            }
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void counterChanged(IAvGPMCounterDefinition pCounterDef) {
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.getPath((AvPMCounterNode)pCounterDef)));
    }

    public void counterSelected(IAvGPMCounterDefinition pCounterDef) {
        for (AvPMCounterNode node = (AvPMCounterNode)pCounterDef; node != null; node = node.getParent()) {
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.getPath(node)));
        }
    }

    public void counterDeselected(IAvGPMCounterDefinition pCounterDef) {
        for (AvPMCounterNode node = (AvPMCounterNode)pCounterDef; node != null; node = node.getParent()) {
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.getPath(node)));
        }
    }

    public int getColumnCount() {
        return cNames.length - (this.withValueColumn ? 0 : 1);
    }

    public String getColumnName(int column) {
        if (!this.withValueColumn && column == 2) {
            return cNames[column + 1];
        }
        return cNames[column];
    }

    public Class getColumnClass(int column) {
        if (!this.withValueColumn && column == 2) {
            return cTypes[column + 1];
        }
        return cTypes[column];
    }

    public Object getValueAt(Object node, int column) {
        switch (column) {
            case 0: {
                if (node == null) break;
                return node;
            }
            case 1: {
                if (!(node instanceof AvPMCounterNode) || ((AvPMCounterNode)node).isCategory()) break;
                AvPMCounterNode avPMCounterNode = (AvPMCounterNode)node;
                if (avPMCounterNode.isCategory() || !avPMCounterNode.isSelected()) {
                    return null;
                }
                return AvPMCounterStyle.getColor((String)new AvPMCounterStyle(avPMCounterNode.getStyle()).getProperty("line-color"));
            }
            case 2: {
                if (!(node instanceof AvPMCounterNode) || ((AvPMCounterNode)node).isCategory()) break;
                if (this.withValueColumn) {
                    return ((AvPMCounterNode)node).getValueString();
                }
                return ((AvPMCounterNode)node).getScale();
            }
            case 3: {
                if (!(node instanceof AvPMCounterNode) || ((AvPMCounterNode)node).isCategory()) break;
                return ((AvPMCounterNode)node).getScale();
            }
        }
        return "";
    }

    public boolean isCellEditable(Object node, int column) {
        return column == 0 || node instanceof AvPMCounterNode && !((AvPMCounterNode)node).isCategory() && (this.withValueColumn && column == 3 || !this.withValueColumn && column == 2 || column == 1 && ((AvPMCounterNode)node).isSelected());
    }

    public void setValueAt(Object aValue, Object node, int column) {
        if (column == 1 && node instanceof AvPMCounterNode) {
            AvPMCounterStyle counterStyle = new AvPMCounterStyle(((AvPMCounterNode)node).getStyle());
            counterStyle.setProperty("line-color", AvGenericStyle.getColorString((Color)((Color)aValue)));
            ((AvPMCounterNode)node).setStyle(counterStyle.getStyleString());
        } else if ((this.withValueColumn && column == 3 || !this.withValueColumn && column == 2) && node instanceof AvPMCounterNode) {
            ((AvPMCounterNode)node).setScale(((Double)aValue).doubleValue());
        }
    }
}

