/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.performance.viewer.CounterNodeInternationalizer;
import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.apps.pmcollection.AvPMCounterNodeUtil;
import com.ngnms.apps.pmcollection.IAvGPMCounterDefinition;
import com.ngnms.apps.pmcollection.IAvGPMCounterSelector;
import com.ngnms.apps.pmcollection.IAvPMCounterNodeListener;
import com.ngnms.apps.pmcollection.IAvPMCounterProvider;
import com.ngnms.apps.pmcollection.IAvPMCounterSelectorListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CounterSelectorSupport
implements IAvGPMCounterSelector,
IAvPMCounterNodeListener {
    private static final Logger logger = Logger.getLogger(CounterSelectorSupport.class);
    private Hashtable nodes = new Hashtable();
    private Hashtable rootNodes = new Hashtable();
    private Hashtable counterProviders = new Hashtable();
    private HashSet listeners = new HashSet();
    private CounterNodeInternationalizer counterInternationalizer;
    private boolean autoLoadNodes = false;

    public CounterSelectorSupport(CounterNodeInternationalizer counterInternationalizer) {
        this.counterInternationalizer = counterInternationalizer;
    }

    public void addEntity(String pEntityID, IAvPMCounterProvider pCounterProvider, String pRoot) {
        this.counterProviders.put(pEntityID, pCounterProvider);
        if (pRoot == null) {
            pRoot = "Root";
        }
        AvPMCounterNode rootNode = new AvPMCounterNode(null, pEntityID, pRoot, pRoot);
        rootNode.setPMCounterNodeListener((IAvPMCounterNodeListener)this);
        this.rootNodes.put(pEntityID, rootNode);
        rootNode.fillPathHash(this.nodes);
        try {
            CounterSelectorSupport.translateNodes(rootNode, this.counterInternationalizer);
            rootNode.setEntityLabel(pCounterProvider.getEntityLabel(pEntityID));
            AvPMCounterNodeUtil.setNodesDisplayModeByCounterType((AvPMCounterNode)rootNode);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        if (this.autoLoadNodes) {
            this.loadNode(rootNode);
        }
    }

    public void addPMCounterSelectorListener(IAvPMCounterSelectorListener pListener) {
        this.listeners.add(pListener);
    }

    public void removePMCounterSelectorListener(IAvPMCounterSelectorListener pListener) {
        this.listeners.remove(pListener);
    }

    public void nodeChanged(AvPMCounterNode pNode) {
        if (!pNode.isCategory()) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((IAvPMCounterSelectorListener)i.next()).counterChanged((IAvGPMCounterDefinition)pNode);
            }
        }
    }

    public void nodeDeselected(AvPMCounterNode pNode) {
        if (!pNode.isCategory()) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((IAvPMCounterSelectorListener)i.next()).counterDeselected((IAvGPMCounterDefinition)pNode);
            }
            pNode.setValue(0.0);
        }
        if (pNode.isCategory()) {
            AvPMCounterNodeUtil.setNodesSelected((AvPMCounterNode)pNode, (boolean)false);
        }
    }

    public void nodeSelected(AvPMCounterNode pNode) {
        if (pNode.isCategory() && !pNode.isLoaded()) {
            this.loadNode(pNode);
        }
        if (!pNode.isCategory()) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((IAvPMCounterSelectorListener)i.next()).counterSelected((IAvGPMCounterDefinition)pNode);
            }
        }
        if (pNode.isCategory()) {
            AvPMCounterNodeUtil.setNodesSelected((AvPMCounterNode)pNode, (boolean)true);
        }
    }

    public void removeEntity(String pEntityID) {
        logger.debug((Object)("removeEntity - " + pEntityID));
    }

    public void setCounterValue(String pCounterID, double pValue, boolean pOverflow) {
        this.setCounterValues(new String[]{pCounterID}, new double[]{pValue}, new boolean[]{pOverflow});
    }

    public void setCounterValues(String[] pCounterIDs, double[] pValues, boolean[] pOverflow) {
        for (int i = 0; i < pCounterIDs.length; ++i) {
            AvPMCounterNode node = (AvPMCounterNode)this.nodes.get(pCounterIDs[i]);
            if (node.isSelected()) {
                node.setValue(pValues[i]);
                continue;
            }
            node.setValue(0.0);
        }
    }

    public void loadNode(AvPMCounterNode pRootNode) {
        if (pRootNode == null || !pRootNode.isCategory() || pRootNode.isLoaded()) {
            return;
        }
        String entityID = pRootNode.getEntityID();
        IAvPMCounterProvider counterProvider = (IAvPMCounterProvider)this.counterProviders.get(entityID);
        Object counterData = counterProvider.getCounters(entityID, pRootNode.getName(), -1);
        if (counterData != null) {
            pRootNode.load(counterData);
        }
        pRootNode.setPMCounterNodeListener((IAvPMCounterNodeListener)this);
        pRootNode.fillPathHash(this.nodes);
        if (null != this.counterInternationalizer) {
            CounterSelectorSupport.translateNodes(pRootNode, this.counterInternationalizer);
            AvPMCounterNodeUtil.setNodesEntityLabel((AvPMCounterNode)pRootNode, (String)pRootNode.getEntityLabel());
        }
        AvPMCounterNodeUtil.setNodesDisplayModeByCounterType((AvPMCounterNode)pRootNode);
    }

    public AvPMCounterNode getRootNode(String pEntityID) {
        return (AvPMCounterNode)this.rootNodes.get(pEntityID);
    }

    public void setCounterSelected(String pCounterID, boolean pSelected) {
        AvPMCounterNode node = (AvPMCounterNode)this.nodes.get(pCounterID);
        if (node != null && !node.isCategory()) {
            node.setSelected(pSelected);
        }
    }

    public void setCounterSubtreeSelected(String pCounterID, boolean pSelected) {
        AvPMCounterNode node = (AvPMCounterNode)this.nodes.get(pCounterID);
        if (node != null && node.isCategory()) {
            AvPMCounterNodeUtil.setNodesSelected((AvPMCounterNode)node, (boolean)pSelected);
        }
    }

    public void setEntityCountersSelected(String pEntityID, boolean pSelected) {
        AvPMCounterNode rootNode = this.getRootNode(pEntityID);
        if (rootNode != null) {
            AvPMCounterNodeUtil.setNodesSelected((AvPMCounterNode)rootNode, (boolean)pSelected);
        }
    }

    public AvPMCounterNode getNode(String pCounterID) {
        return (AvPMCounterNode)this.nodes.get(pCounterID);
    }

    public boolean isAutoLoadNodes() {
        return this.autoLoadNodes;
    }

    public void setAutoLoadNodes(boolean autoLoadNodes) {
        this.autoLoadNodes = autoLoadNodes;
    }

    public Collection getEntities() {
        return this.rootNodes.keySet();
    }

    public static void translateNodes(AvPMCounterNode pRootNode, final CounterNodeInternationalizer internationalizer) {
        pRootNode.visit(new AvPMCounterNode.Visitor(){

            public void visit(AvPMCounterNode pNode) {
                if (!pNode.isTranslated()) {
                    internationalizer.translateNode(pNode);
                    pNode.setTranslated(true);
                }
            }
        });
    }
}

