/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.viewer;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.util.AbstractTreeCellEditor;
import com.bwanms.gui.util.treetable.JTreeTable;
import com.bwanms.util.MessageBox;
import com.ngnms.apps.pmcollection.AvPMCounterNode;
import com.ngnms.apps.pmcollection.AvPMCounterNodeUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class CounterNodeTreeCellEditor
extends AbstractTreeCellEditor {
    private AvPMCounterNode value = null;
    private JCheckBox chkCounter = new JCheckBox();
    private JTreeTable jTreeTable;
    private static Internationalizer i18n = Internationalizer.getInternationalizer(CounterNodeTreeCellEditor.class);

    public CounterNodeTreeCellEditor(JTreeTable jTreeTable) {
        this.jTreeTable = jTreeTable;
        this.initComponents();
    }

    private void initComponents() {
        this.chkCounter.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (CounterNodeTreeCellEditor.this.value != null) {
                    if (!CounterNodeTreeCellEditor.this.value.isCategory()) {
                        CounterNodeTreeCellEditor.this.value.setSelected(!CounterNodeTreeCellEditor.this.value.isSelected());
                    } else {
                        AvPMCounterNodeUtil.setNodesSelected((AvPMCounterNode)CounterNodeTreeCellEditor.this.value, (!CounterNodeTreeCellEditor.this.value.hasAllChildrenSelected() ? 1 : 0) != 0);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CounterNodeTreeCellEditor.this.jTreeTable.dispatchEvent(new KeyEvent(CounterNodeTreeCellEditor.this.jTreeTable, 401, new Date().getTime(), 0, 27, '\uffff'));
                        }
                    });
                }
                if (CounterNodeTreeCellEditor.this.value.getParent() == null && (CounterNodeTreeCellEditor.this.value.getChildren() == null || CounterNodeTreeCellEditor.this.value.getChildren().size() == 0)) {
                    MessageBox.Alert.quickShow(CounterNodeTreeCellEditor.this.chkCounter, i18n.translateString("ThisEntityHasNoCounter"));
                    CounterNodeTreeCellEditor.this.value.setGrayedOut(true);
                    CounterNodeTreeCellEditor.this.chkCounter.setEnabled(false);
                    CounterNodeTreeCellEditor.this.chkCounter.setSelected(false);
                }
            }
        });
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        if (value instanceof AvPMCounterNode) {
            AvPMCounterNode val;
            this.value = val = (AvPMCounterNode)value;
            if (val.isCategory()) {
                if (val.getParent() == null) {
                    this.chkCounter.setText(val.getEntityLabel() + " - " + val.getLabel());
                } else {
                    this.chkCounter.setText(val.getLabel());
                }
                this.chkCounter.setSelected(val.hasAllChildrenSelected());
            } else {
                this.chkCounter.setText(val.getLabel());
                this.chkCounter.setSelected(val.isSelected());
            }
            if (!val.isGrayedOut()) {
                this.chkCounter.setForeground(selected ? this.textSelectionColor : this.textNonSelectionColor);
            }
            this.chkCounter.setBackground(selected ? this.backgroundSelectionColor : this.backgroundNonSelectionColor);
            this.chkCounter.setEnabled(!val.isGrayedOut());
        } else {
            this.value = null;
        }
        return this.chkCounter;
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped(new ChangeEvent(this));
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled(new ChangeEvent(this));
    }
}

