/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.db;

import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.services.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import org.apache.log4j.Logger;

class PmSQLHelper {
    private static final Logger log = Logger.getLogger(PmSQLHelper.class);

    private PmSQLHelper() {
    }

    static byte[] serializeObject(Serializable object) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(object);
        oout.close();
        out.close();
        return out.toByteArray();
    }

    static Serializable deserializeObject(byte[] serializedForm) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(serializedForm);
        ObjectInputStream oin = new ObjectInputStream(in);
        Serializable ret = (Serializable)oin.readObject();
        oin.close();
        return ret;
    }

    static Serializable deserializeObject(InputStream in) throws Exception {
        ObjectInputStream oin = new ObjectInputStream(in);
        Serializable ret = (Serializable)oin.readObject();
        oin.close();
        return ret;
    }

    static byte[] serializeDoubles(double[] pValues) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeByte(1);
        oout.writeInt(pValues.length);
        for (int i = 0; i < pValues.length; ++i) {
            oout.writeDouble(pValues[i]);
        }
        oout.close();
        out.close();
        return out.toByteArray();
    }

    static double[] deserializeDoubles(byte[] serializedForm) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(serializedForm);
        return PmSQLHelper.deserializeDoubles(in);
    }

    static double[] deserializeDoubles(InputStream in) throws Exception {
        ObjectInputStream oin = new ObjectInputStream(in);
        byte _type = oin.readByte();
        if (1 != _type) {
            throw new IllegalArgumentException("Unknown Serialization type!");
        }
        int _sz = oin.readInt();
        double[] ret = new double[_sz];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = oin.readDouble();
        }
        return ret;
    }

    static byte[] serializeIntegers(int[] pValues) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeByte(1);
        oout.writeInt(pValues.length);
        for (int i = 0; i < pValues.length; ++i) {
            oout.writeInt(pValues[i]);
        }
        oout.close();
        out.close();
        return out.toByteArray();
    }

    static int[] deserializeIntegers(byte[] serializedForm) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(serializedForm);
        return PmSQLHelper.deserializeIntegers(in);
    }

    static int[] deserializeIntegers(InputStream in) throws Exception {
        ObjectInputStream oin = new ObjectInputStream(in);
        byte _type = oin.readByte();
        if (1 != _type) {
            throw new IllegalArgumentException("Unknown Serialization type!");
        }
        int _sz = oin.readInt();
        int[] ret = new int[_sz];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = oin.readInt();
        }
        return ret;
    }

    static Connection getConnection() throws ServiceException {
        return JDBCConnectionProvider.getConnection();
    }

    static void returnConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

