/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.db;

import com.bwanms.performance.db.PmDataCollector;
import com.bwanms.performance.db.PmDataEntry;
import com.bwanms.performance.db.PmSQLHelper;
import com.bwanms.services.ServiceException;
import com.ngnms.apps.pmcollection.db.AvPmDataItem;
import com.ngnms.apps.pmcollection.db.AvPmDisplayData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmDirectDataCollector
extends PmDataCollector {
    private static final Logger logger = Logger.getLogger(PmDirectDataCollector.class);
    private static int COMMIT_SIZE = Integer.getInteger("com.ngnms.apps.pmcollection.db.AvPmDirectSessionDataCollector.commitSize", 40);
    private static int oldDataCheckInterval = Integer.getInteger("com.ngnms.apps.pmcollection.db.AvPmDirectSessionDataCollector.checkOldDataInterval", 100);
    private static final String PM_DATA_TABLE_NAME = "AVPMCOLLECTIONRDATA";
    private static final String PM_CONFIG_TABLE_NAME = "AVPMCOLLECTIONRCONFIG";
    private static int[] rraCollIntervals;
    private static int[] rraNumberOfRows;
    private String sessionID;
    private int interval;
    private int numberOfRows;
    private TreeMap<String, TreeMap<String, PmCollectionConfig>>[] configValues;
    private int timeToNextOldDataCheck = oldDataCheckInterval;
    private static final String insertDataStr = "INSERT INTO AVPMCOLLECTIONRDATA (SEQID, CRTSEQ, COLLECTIONTIME, CDATA) VALUES(?, ?, ?, ?)";
    private static final String updateDataStr = "UPDATE AVPMCOLLECTIONRDATA SET COLLECTIONTIME = ?, CDATA = ? WHERE SEQID = ? AND CRTSEQ = ?";
    private static final String insertConfigDataStr = "INSERT INTO AVPMCOLLECTIONRCONFIG (SESSIONID, DEVICEID, TROWID, CLEVEL, SEQID, SEQTOUPDATE, CRTSEQ, COLLECTIONTIME, CDATA, CCOUNTS) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String updateConfigDataStr = "UPDATE AVPMCOLLECTIONRCONFIG SET CRTSEQ = ?, SEQTOUPDATE = ?, COLLECTIONTIME = ?, CDATA = ?, CCOUNTS = ? WHERE SEQID = ?";
    private static long sequenceIdBase;

    public PmDirectDataCollector(String pSessionID, int pInterval) {
        this.sessionID = pSessionID;
        this.interval = pInterval;
        this.numberOfRows = Math.max(604800 / pInterval, 10);
        logger.debug((Object)"PmDirectSessionDataCollector: -------------------------------------------------- ");
        logger.debug((Object)("sessionID: " + this.sessionID + "\tinterval: " + this.interval + " number of rows " + this.numberOfRows));
        long _tm = System.currentTimeMillis();
        this.initSession();
        logger.debug((Object)("PmDirectSessionDataCollector: initSession() in " + (System.currentTimeMillis() - _tm) + " millis."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AvPmDisplayData> getDisplayDataValues(String pSessionID, String pDeviceID, Vector<String> pRowIDs, long pStartTime, long pEndTime) throws Exception {
        if (null == pSessionID || null == pDeviceID) {
            throw new IllegalArgumentException("SessionID and DeviceID cannot be null.");
        }
        long crtTime = System.currentTimeMillis();
        int level = PmDirectDataCollector.getDisplayLevel(crtTime, pStartTime, pEndTime);
        logger.debug((Object)("getDisplayDataValues() - get data using level: " + level));
        Vector<AvPmDisplayData> ret = new Vector<AvPmDisplayData>();
        Connection conn = null;
        try {
            conn = PmSQLHelper.getConnection();
            StringBuffer query = new StringBuffer("SELECT TBL_CFG.TROWID AS DROWID, TBL_DATA.COLLECTIONTIME AS DTIME, TBL_DATA.CDATA AS DDATA FROM ");
            query.append("AVPMCOLLECTIONRCONFIG TBL_CFG, ");
            query.append("AVPMCOLLECTIONRDATA TBL_DATA");
            query.append(" WHERE TBL_CFG.SESSIONID = ? AND TBL_CFG.DEVICEID = ?");
            if (null != pRowIDs && pRowIDs.size() > 0) {
                query.append(" AND TBL_CFG.TROWID IN (?");
                for (int i = 1; i < pRowIDs.size(); ++i) {
                    query.append(",?");
                }
                query.append(')');
            }
            query.append(" AND TBL_CFG.CLEVEL = ?");
            query.append(" AND TBL_CFG.COLLECTIONTIME > 0");
            query.append(" AND TBL_CFG.SEQID = TBL_DATA.SEQID");
            if (-1L != pStartTime) {
                query.append(" AND TBL_DATA.COLLECTIONTIME >= ?");
            }
            if (-1L != pEndTime) {
                query.append(" AND TBL_DATA.COLLECTIONTIME <= ?");
            }
            if (null != pRowIDs && pRowIDs.size() > 1) {
                query.append(" ORDER BY TBL_DATA.COLLECTIONTIME, TBL_CFG.TROWID");
            } else {
                query.append(" ORDER BY TBL_DATA.COLLECTIONTIME");
            }
            logger.debug((Object)("getDisplayDataValues() - QUERY is [" + query.toString() + "]"));
            PreparedStatement stat = conn.prepareStatement(query.toString());
            int _par = 1;
            stat.setString(_par++, pSessionID);
            stat.setString(_par++, pDeviceID);
            if (null != pRowIDs && pRowIDs.size() > 0) {
                for (int i = 0; i < pRowIDs.size(); ++i) {
                    stat.setString(_par++, pRowIDs.get(i));
                }
            }
            stat.setInt(_par++, level);
            if (-1L != pStartTime) {
                stat.setLong(_par++, pStartTime);
            }
            if (-1L != pEndTime) {
                stat.setLong(_par++, pEndTime);
            }
            ResultSet rs = stat.executeQuery();
            while (rs.next()) {
                AvPmDisplayData dData = new AvPmDisplayData(rs.getString("DROWID"), rs.getLong("DTIME"), PmSQLHelper.deserializeDoubles(rs.getBinaryStream("DDATA")));
                ret.add(dData);
            }
            rs.close();
            stat.close();
        }
        catch (ServiceException e) {
            logger.error((Object)"Can't create jdbc connection ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            PmSQLHelper.returnConnection(conn);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getRowInstances(String pSessionID, String pDeviceID) {
        if (null == pSessionID || null == pDeviceID) {
            throw new IllegalArgumentException("SessionID and DeviceID cannot be null.");
        }
        Vector<String> ret = new Vector<String>();
        Connection conn = null;
        try {
            conn = PmSQLHelper.getConnection();
            String query = "SELECT DISTINCT TROWID FROM AVPMCOLLECTIONRCONFIG WHERE SESSIONID = ? AND DEVICEID = ? AND COLLECTIONTIME > 0";
            PreparedStatement stat = conn.prepareStatement(query);
            stat.setString(1, pSessionID);
            stat.setString(2, pDeviceID);
            ResultSet rs = stat.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString("TROWID"));
            }
            rs.close();
            stat.close();
            logger.debug((Object)("getRowInstances() - SELECTED ROWIDs size: " + ret.size()));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            PmSQLHelper.returnConnection(conn);
        }
        return ret;
    }

    public static void deleteSessionData(String pSessionID) throws Exception {
        PmDirectDataCollector.deleteData(pSessionID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteData(String pSessionID, String pDeviceID) throws Exception {
        if (null == pSessionID) {
            throw new Exception("Delete with NO session specified!  NOT SUPPORTED.");
        }
        Connection conn = null;
        try {
            conn = PmSQLHelper.getConnection();
            conn.setAutoCommit(false);
            StringBuffer query = new StringBuffer("UPDATE ");
            query.append(PM_CONFIG_TABLE_NAME);
            query.append(" SET COLLECTIONTIME = 0");
            query.append(" WHERE SESSIONID = ?");
            if (null != pDeviceID) {
                query.append(" AND DEVICEID = ?");
            }
            PreparedStatement stat = conn.prepareStatement(query.toString());
            int _par = 1;
            stat.setString(_par++, pSessionID);
            if (null != pDeviceID) {
                stat.setString(_par++, pDeviceID);
            }
            stat.execute();
            conn.commit();
            int updateCount = stat.getUpdateCount();
            stat.close();
            logger.debug((Object)("Updated " + updateCount + " CONFIG records."));
        }
        finally {
            PmSQLHelper.returnConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePmData(List<AvPmDataItem> pDataItems) {
        if (null == this.configValues) {
            this.initSession();
        }
        Connection conn = null;
        try {
            int _sz = pDataItems.size();
            if (logger.isDebugEnabled()) {
                for (int i = 0; i < _sz; ++i) {
                    logger.debug((Object)String.format("AvPmDataItem %d: %s", i, pDataItems.get(i).toString()));
                }
            }
            conn = PmSQLHelper.getConnection();
            Vector<PmDataEntry> allValues = new Vector<PmDataEntry>(_sz);
            for (int d = 0; d < _sz; ++d) {
                AvPmDataItem dataItem = pDataItems.get(d);
                if (!dataItem.isSuccess()) continue;
                PmDataEntry rcdata = new PmDataEntry();
                String devID = dataItem.getEntityID();
                rcdata.setDeviceID(devID);
                String rowID = dataItem.getRowID();
                rcdata.setRowID(rowID);
                rcdata.setCLevel(0);
                rcdata.setCollectionTime(dataItem.getTimestamp());
                rcdata.setData(dataItem.getValues());
                allValues.add(rcdata);
                PmCollectionConfig crtDevVals = this.getConfigValue(devID, rowID, 0);
                if (null == crtDevVals) continue;
                crtDevVals.cTime = rcdata.getCollectionTime();
                crtDevVals.values = rcdata.getData();
            }
            int allValuesSize = allValues.size();
            if (logger.isDebugEnabled()) {
                for (int i = 0; i < allValuesSize; ++i) {
                    logger.debug((Object)String.format("PmDataEntry %d: %s", i, ((PmDataEntry)allValues.get(i)).toString()));
                }
            }
            long _st1tm = System.currentTimeMillis();
            for (int _startIdx = 0; _startIdx < allValuesSize; _startIdx += COMMIT_SIZE) {
                List<PmDataEntry> toWrite = allValues.subList(_startIdx, Math.min(_startIdx + COMMIT_SIZE, allValuesSize));
                this.addPmValues(conn, toWrite);
            }
            logger.debug((Object)("storePmData(): STEP 1 DONE IN " + (System.currentTimeMillis() - _st1tm) + " ms.   ( size is " + allValuesSize + " )"));
            long _st2tm = System.currentTimeMillis();
            this.aggregatePmData(conn, allValues);
            logger.debug((Object)("storePmData(): STEP 2 DONE IN " + (System.currentTimeMillis() - _st2tm) + " ms.   ( size is " + allValuesSize + " )"));
        }
        catch (Throwable e) {
            try {
                logger.error((Object)e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                PmSQLHelper.returnConnection(conn);
                throw throwable;
            }
            PmSQLHelper.returnConnection(conn);
        }
        PmSQLHelper.returnConnection(conn);
    }

    public Map<Object, Object> getLastValues(long pCrtTime) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        return ret;
    }

    @Override
    public void cycleStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cycleFinished() {
        logger.debug((Object)"CYCLE FINISHED.");
        if (0 >= --this.timeToNextOldDataCheck) {
            this.timeToNextOldDataCheck = oldDataCheckInterval;
            long crtTime = System.currentTimeMillis();
            if (null == this.configValues) {
                this.initSession();
            }
            TreeMap verified = new TreeMap();
            Vector<Long> tempIDs = new Vector<Long>(this.configValues.length);
            TreeSet<Long> _toDelete = new TreeSet<Long>();
            for (int i = 0; i < this.configValues.length; ++i) {
                for (String devID : this.configValues[i].keySet()) {
                    TreeSet<String> vtrows = (TreeSet<String>)verified.get(devID);
                    if (null == vtrows) {
                        vtrows = new TreeSet<String>();
                        verified.put(devID, vtrows);
                    }
                    TreeMap<String, PmCollectionConfig> ltrows = this.configValues[i].get(devID);
                    for (String rowID : ltrows.keySet()) {
                        if (vtrows.contains(rowID)) continue;
                        vtrows.add(rowID);
                        boolean bToDelete = true;
                        tempIDs.clear();
                        for (int l = 0; l < this.configValues.length; ++l) {
                            long _numrows;
                            PmCollectionConfig devVals = this.getConfigValue(devID, rowID, l);
                            if (null == devVals) continue;
                            long _int = 0 == l ? (long)this.interval : (long)rraCollIntervals[l - 1];
                            long limitTime = crtTime - _int * (_numrows = 0 == l ? (long)this.numberOfRows : (long)rraNumberOfRows[l - 1]) * 1000L;
                            if (devVals.cTime >= limitTime) {
                                bToDelete = false;
                                break;
                            }
                            tempIDs.add(new Long(devVals.sequenceID));
                        }
                        if (!bToDelete) continue;
                        _toDelete.addAll(tempIDs);
                    }
                }
            }
            logger.debug((Object)("cycleFinished: TO DELETE size is " + _toDelete.size()));
            if (_toDelete.size() > 0) {
                Connection conn = null;
                try {
                    conn = PmSQLHelper.getConnection();
                    String updateCfg = "UPDATE AVPMCOLLECTIONRCONFIG SET COLLECTIONTIME = 0 WHERE SEQID = ?";
                    PreparedStatement stat = conn.prepareStatement(updateCfg);
                    int _sz = 0;
                    Iterator it = _toDelete.iterator();
                    while (it.hasNext()) {
                        stat.setLong(1, (Long)it.next());
                        stat.addBatch();
                        if (++_sz != COMMIT_SIZE && it.hasNext()) continue;
                        _sz = 0;
                        stat.executeBatch();
                        conn.commit();
                        stat.close();
                        if (!it.hasNext()) continue;
                        stat = conn.prepareStatement(updateCfg);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return;
                }
                finally {
                    PmSQLHelper.returnConnection(conn);
                }
                this.initSession();
            }
        }
    }

    private void initSession() {
        int n = RRA_COLLECTION_INTERVALS_SEC.length;
        this.configValues = new TreeMap[n + 1];
        for (int i = 0; i < this.configValues.length; ++i) {
            this.configValues[i] = new TreeMap();
        }
        Connection conn = null;
        try {
            conn = PmSQLHelper.getConnection();
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("SELECT DEVICEID, TROWID, CLEVEL, COLLECTIONTIME, SEQID, CRTSEQ, SEQTOUPDATE, CDATA, CCOUNTS FROM AVPMCOLLECTIONRCONFIG WHERE SESSIONID = '" + this.sessionID + "' AND COLLECTIONTIME > 0");
            while (rs.next()) {
                String devID = rs.getString("DEVICEID");
                String rowID = rs.getString("TROWID");
                int clevel = rs.getInt("CLEVEL");
                long ctime = rs.getLong("COLLECTIONTIME");
                PmCollectionConfig crtDevVals = new PmCollectionConfig(ctime, rs.getLong("SEQID"), rs.getInt("CRTSEQ"), 1 == rs.getInt("SEQTOUPDATE"), PmSQLHelper.deserializeDoubles(rs.getBinaryStream("CDATA")), PmSQLHelper.deserializeIntegers(rs.getBinaryStream("CCOUNTS")));
                this.putConfigValue(devID, rowID, clevel, crtDevVals);
            }
            rs.close();
            stat.close();
        }
        catch (Exception sqle) {
            logger.error((Object)sqle);
            this.configValues = null;
            throw new RuntimeException(sqle.getMessage());
        }
        finally {
            PmSQLHelper.returnConnection(conn);
        }
    }

    private void addPmValues(Connection conn, List<PmDataEntry> pValues) {
        try {
            PreparedStatement insertData;
            conn.setAutoCommit(false);
            Vector<PmCollectionConfig> configToInsert = new Vector<PmCollectionConfig>();
            Vector<PmDataEntry> valuesToInsert = new Vector<PmDataEntry>();
            Vector<PmCollectionConfig> configToUpdate = new Vector<PmCollectionConfig>();
            Vector<PmDataEntry> valuesToUpdate = new Vector<PmDataEntry>();
            for (PmDataEntry rcdata : pValues) {
                PmCollectionConfig devVals = this.getConfigValue(rcdata.getDeviceID(), rcdata.getRowID(), rcdata.getCLevel());
                if (null == devVals || -1L == devVals.sequenceID) {
                    valuesToInsert.add(rcdata);
                    devVals = new PmCollectionConfig(rcdata.getCollectionTime(), -1L, 0, false, rcdata.getData());
                    configToInsert.add(devVals);
                    continue;
                }
                configToUpdate.add(devVals);
                valuesToUpdate.add(rcdata);
            }
            if (!valuesToInsert.isEmpty()) {
                insertData = conn.prepareStatement(insertDataStr);
                PreparedStatement insertConfigData = conn.prepareStatement(insertConfigDataStr);
                Iterator itc = configToInsert.iterator();
                Iterator it = valuesToInsert.iterator();
                while (it.hasNext()) {
                    long seqID = PmDirectDataCollector.createNextSequenceId();
                    PmDataEntry rcdata = (PmDataEntry)it.next();
                    PmCollectionConfig devVals = (PmCollectionConfig)itc.next();
                    devVals.sequenceID = seqID;
                    devVals.crtSequence = null == rcdata.getData() ? -1 : 0;
                    insertConfigData.setString(1, this.sessionID);
                    insertConfigData.setString(2, rcdata.getDeviceID());
                    insertConfigData.setString(3, rcdata.getRowID());
                    insertConfigData.setLong(4, rcdata.getCLevel());
                    insertConfigData.setLong(5, seqID);
                    insertConfigData.setInt(6, 0);
                    insertConfigData.setInt(7, devVals.crtSequence);
                    insertConfigData.setLong(8, devVals.cTime);
                    insertConfigData.setBytes(9, PmSQLHelper.serializeDoubles(devVals.values));
                    insertConfigData.setBytes(10, PmSQLHelper.serializeIntegers(devVals.counts));
                    insertConfigData.addBatch();
                    if (null == rcdata.getData()) continue;
                    insertData.setLong(1, seqID);
                    insertData.setInt(2, 0);
                    insertData.setLong(3, rcdata.getCollectionTime());
                    insertData.setBytes(4, PmSQLHelper.serializeDoubles(rcdata.getData()));
                    insertData.addBatch();
                }
                insertConfigData.executeBatch();
                insertData.executeBatch();
                conn.commit();
                itc = configToInsert.iterator();
                for (PmDataEntry rcdata : valuesToInsert) {
                    PmCollectionConfig newDevVal = (PmCollectionConfig)itc.next();
                    this.putConfigValue(rcdata.getDeviceID(), rcdata.getRowID(), rcdata.getCLevel(), newDevVal);
                }
                insertData.close();
                insertConfigData.close();
            }
            if (!valuesToUpdate.isEmpty()) {
                PmCollectionConfig devVals;
                insertData = conn.prepareStatement(insertDataStr);
                PreparedStatement updateData = conn.prepareStatement(updateDataStr);
                PreparedStatement updateConfigData = conn.prepareStatement(updateConfigDataStr);
                Iterator itc = configToUpdate.iterator();
                for (PmDataEntry rcdata : valuesToUpdate) {
                    devVals = (PmCollectionConfig)itc.next();
                    int clevel = rcdata.getCLevel();
                    boolean toUpdate = devVals.toUpdate;
                    int crtSeq = devVals.crtSequence;
                    if (null != rcdata.getData()) {
                        int maxSeq;
                        int n = maxSeq = 0 == clevel ? this.numberOfRows : rraNumberOfRows[clevel - 1];
                        if (crtSeq == maxSeq - 1) {
                            toUpdate = true;
                            crtSeq = 0;
                        } else {
                            ++crtSeq;
                        }
                    }
                    rcdata.setCrtSequence(crtSeq);
                    rcdata.setToUpdate(toUpdate);
                    updateConfigData.setInt(1, crtSeq);
                    updateConfigData.setInt(2, toUpdate ? 1 : 0);
                    updateConfigData.setLong(3, devVals.cTime);
                    updateConfigData.setBytes(4, PmSQLHelper.serializeDoubles(devVals.values));
                    updateConfigData.setBytes(5, PmSQLHelper.serializeIntegers(devVals.counts));
                    updateConfigData.setLong(6, devVals.sequenceID);
                    updateConfigData.addBatch();
                    logger.debug((Object)String.format("[UPDATE 'AVPMCOLLECTIONRCONFIG' table. BATCH...] CRTSEQ = %d, SEQTOUPDATE = %d, COLLECTIONTIME = %d, SEQID = %d", crtSeq, toUpdate ? 1 : 0, devVals.cTime, devVals.sequenceID));
                    if (null == rcdata.getData()) continue;
                    byte[] serializeDoubles = PmSQLHelper.serializeDoubles(rcdata.getData());
                    long collectionTime = rcdata.getCollectionTime();
                    if (!toUpdate) {
                        insertData.setLong(1, devVals.sequenceID);
                        insertData.setInt(2, crtSeq);
                        insertData.setLong(3, collectionTime);
                        insertData.setBytes(4, serializeDoubles);
                        insertData.addBatch();
                        logger.debug((Object)String.format("[INSER 'AVPMCOLLECTIONRDATA' table. BATCH...] SEQID = %d, CRTSEQ = %d, COLLECTIONTIME = %d", devVals.sequenceID, crtSeq, collectionTime));
                        continue;
                    }
                    updateData.setLong(1, collectionTime);
                    updateData.setBytes(2, serializeDoubles);
                    updateData.setLong(3, devVals.sequenceID);
                    updateData.setInt(4, crtSeq);
                    updateData.addBatch();
                    logger.debug((Object)String.format("[UPDATE 'AVPMCOLLECTIONRDATA' table. BATCH...] SEQID = %d, CRTSEQ = %d, COLLECTIONTIME = %d", devVals.sequenceID, crtSeq, collectionTime));
                }
                updateConfigData.executeBatch();
                logger.debug((Object)String.format("[UPDATE 'AVPMCOLLECTIONRCONFIG' table. BATCHED] Finished.", new Object[0]));
                updateData.executeBatch();
                logger.debug((Object)String.format("[UPDATE 'AVPMCOLLECTIONRDATA' BATCHED] Finished.", new Object[0]));
                insertData.executeBatch();
                logger.debug((Object)String.format("[INSERT 'AVPMCOLLECTIONRDATA' BATCHED] Finished.", new Object[0]));
                conn.commit();
                itc = configToUpdate.iterator();
                for (PmDataEntry rcdata : valuesToUpdate) {
                    devVals = (PmCollectionConfig)itc.next();
                    devVals.crtSequence = rcdata.getCrtSequence();
                    devVals.toUpdate = rcdata.isToUpdate();
                }
                updateConfigData.close();
                updateData.close();
                insertData.close();
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle.getLocalizedMessage(), (Throwable)sqle);
            try {
                conn.rollback();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            this.configValues = null;
        }
        catch (Throwable e) {
            logger.error((Object)e);
            try {
                conn.rollback();
            }
            catch (Exception sqle) {
                logger.error((Object)sqle);
            }
        }
    }

    private static synchronized long createNextSequenceId() throws SQLException {
        if (0L == sequenceIdBase) {
            Connection conn = null;
            try {
                conn = PmSQLHelper.getConnection();
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery("SELECT MAX( SEQID ) AS MAX_SEQID FROM AVPMCOLLECTIONRCONFIG");
                sequenceIdBase = rs.next() ? rs.getLong("MAX_SEQID") : 0L;
                rs.close();
                stat.close();
            }
            catch (ServiceException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SQLException("Can't create next sequence id " + e.getMessage());
            }
            finally {
                PmSQLHelper.returnConnection(conn);
            }
        }
        return ++sequenceIdBase;
    }

    private void aggregatePmData(Connection conn, List<PmDataEntry> pValues) throws Exception {
        Vector<PmDataEntry> toCommit = new Vector<PmDataEntry>();
        for (PmDataEntry rdata : pValues) {
            String devID = rdata.getDeviceID();
            String rowID = rdata.getRowID();
            long collTime = rdata.getCollectionTime();
            double[] values = rdata.getData();
            boolean bNextLevel = true;
            for (int l = 0; bNextLevel && l < rraCollIntervals.length; ++l) {
                long rraTime = PmDirectDataCollector.getRoundTime(collTime, rraCollIntervals[l]);
                PmCollectionConfig crtDevVals = this.getConfigValue(devID, rowID, l + 1);
                if (null != crtDevVals && rraTime > crtDevVals.cTime) {
                    int lastInterval;
                    int n = lastInterval = 0 == l ? this.interval : rraCollIntervals[l - 1];
                    if (crtDevVals.checkValuesCount(rraCollIntervals[l] / lastInterval / 2)) {
                        PmDataEntry rcdata = new PmDataEntry();
                        rcdata.setDeviceID(devID);
                        rcdata.setRowID(rowID);
                        rcdata.setCLevel(l + 1);
                        rcdata.setCollectionTime(crtDevVals.cTime);
                        rcdata.setData(crtDevVals.values);
                        toCommit.add(rcdata);
                        crtDevVals.resetValues(rraTime);
                        crtDevVals.addValues(values);
                        bNextLevel = true;
                        values = crtDevVals.values;
                        collTime = crtDevVals.cTime;
                    } else {
                        crtDevVals.resetValues(rraTime);
                        crtDevVals.addValues(values);
                    }
                } else {
                    bNextLevel = false;
                    if (null == crtDevVals) {
                        crtDevVals = new PmCollectionConfig(rraTime, -1L, 0, false, values);
                        this.putConfigValue(devID, rowID, l + 1, crtDevVals);
                    } else {
                        crtDevVals.addValues(values);
                    }
                    if (l < rraCollIntervals.length - 1) {
                        PmDataEntry rcdata = new PmDataEntry();
                        rcdata.setDeviceID(devID);
                        rcdata.setRowID(rowID);
                        rcdata.setCLevel(l + 1);
                        rcdata.setCollectionTime(crtDevVals.cTime);
                        rcdata.setData(null);
                        toCommit.add(rcdata);
                    }
                }
                if (COMMIT_SIZE >= toCommit.size()) continue;
                this.addPmValues(conn, toCommit);
                toCommit.clear();
            }
        }
        if (toCommit.size() > 0) {
            this.addPmValues(conn, toCommit);
        }
    }

    private PmCollectionConfig getConfigValue(String pDeviceID, String pRowID, int pCLevel) {
        TreeMap<String, PmCollectionConfig> trows = this.configValues[pCLevel].get(pDeviceID);
        return null != trows ? trows.get(pRowID) : null;
    }

    private void putConfigValue(String pDeviceID, String pRowID, int pCLevel, PmCollectionConfig pDevVals) {
        TreeMap<String, PmCollectionConfig> trows = this.configValues[pCLevel].get(pDeviceID);
        if (trows == null) {
            trows = new TreeMap();
            this.configValues[pCLevel].put(pDeviceID, trows);
        }
        trows.put(pRowID, pDevVals);
    }

    static {
        int n = RRA_COLLECTION_INTERVALS_SEC.length;
        rraCollIntervals = new int[n];
        rraNumberOfRows = new int[n];
        for (int i = 0; i < n; ++i) {
            PmDirectDataCollector.rraCollIntervals[i] = RRA_COLLECTION_INTERVALS_SEC[i];
            PmDirectDataCollector.rraNumberOfRows[i] = RRA_COLLECTION_ROW_COUNT[i];
        }
        new CleanUpThread().start();
        sequenceIdBase = 0L;
    }

    private static class CleanUpThread
    extends Thread {
        static int intervalInMinutes = Integer.getInteger("com.ngnms.apps.pmcollection.AvPmCollectionCheckOldData.interval", 1440);

        private CleanUpThread() {
        }

        public void run() {
            while (true) {
                for (int i = 0; i < intervalInMinutes; ++i) {
                    try {
                        CleanUpThread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                logger.debug((Object)"PM Collection CleanUpThread woken.");
                CleanUpThread.checkOldData();
                logger.debug((Object)"PM Collection CleanUpThread done.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void checkOldData() {
            logger.debug((Object)"CHECK PM COLLECTION DATA MARKED FOR DELETION.");
            Connection conn = null;
            try {
                conn = PmSQLHelper.getConnection();
                int batchSize = 40;
                boolean bNotDone = true;
                while (bNotDone) {
                    Vector<Long> toDeleteSeqIDs = new Vector<Long>(batchSize);
                    String queryStr = "SELECT SEQID FROM AVPMCOLLECTIONRCONFIG WHERE COLLECTIONTIME = 0";
                    Statement stat = conn.createStatement();
                    ResultSet rs = stat.executeQuery(queryStr);
                    while (rs.next() && toDeleteSeqIDs.size() < batchSize) {
                        toDeleteSeqIDs.add(new Long(rs.getLong("SEQID")));
                    }
                    rs.close();
                    stat.close();
                    bNotDone = toDeleteSeqIDs.size() > 0;
                    Iterator it = toDeleteSeqIDs.iterator();
                    while (it.hasNext()) {
                        long _seqID = (Long)it.next();
                        Statement deleteData = conn.createStatement();
                        deleteData.executeUpdate("DELETE FROM AVPMCOLLECTIONRDATA WHERE SEQID = " + _seqID);
                        Statement deleteCfg = conn.createStatement();
                        deleteCfg.executeUpdate("DELETE FROM AVPMCOLLECTIONRCONFIG WHERE SEQID = " + _seqID);
                        logger.debug((Object)("checkOldData: Deleted Old Data for Sequence: " + _seqID));
                        conn.commit();
                        deleteData.close();
                        deleteCfg.close();
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                PmSQLHelper.returnConnection(conn);
            }
            logger.debug((Object)"DONE PM COLLECTION DATA CHECK.");
        }
    }

    private static class PmCollectionConfig {
        long cTime;
        long sequenceID;
        int crtSequence;
        boolean toUpdate;
        double[] values = new double[0];
        int[] counts = new int[0];

        PmCollectionConfig(long pCTime, long pSequenceID, int pCrtSequence, boolean pToUpdate, double[] pValues, int[] pCounts) {
            this.cTime = pCTime;
            this.sequenceID = pSequenceID;
            this.crtSequence = pCrtSequence;
            this.toUpdate = pToUpdate;
            this.values = pValues;
            this.counts = pCounts;
        }

        PmCollectionConfig(long pCTime, long pSequenceID, int pCrtSequence, boolean pToUpdate, double[] pValues) {
            this.cTime = pCTime;
            this.sequenceID = pSequenceID;
            this.crtSequence = pCrtSequence;
            this.toUpdate = pToUpdate;
            if (null != pValues) {
                this.addValues(pValues);
            }
        }

        void resetValues(long pTime) {
            this.cTime = pTime;
            this.values = new double[0];
            this.counts = new int[0];
        }

        void addValues(double[] pValues) {
            int _sz = pValues.length;
            double[] newvalues = new double[_sz];
            int[] newcounts = new int[_sz];
            for (int i = 0; i < _sz; ++i) {
                int cnt;
                double val = i < this.values.length ? this.values[i] : 0.0;
                int n = cnt = i < this.counts.length ? this.counts[i] : 0;
                if (!Double.isNaN(pValues[i])) {
                    newvalues[i] = cnt > 0 ? ((double)cnt * val + pValues[i]) / (double)(cnt + 1) : pValues[i];
                    newcounts[i] = cnt + 1;
                    continue;
                }
                newvalues[i] = val;
                newcounts[i] = cnt;
            }
            this.values = newvalues;
            this.counts = newcounts;
        }

        boolean checkValuesCount(int pMinCount) {
            boolean _res = false;
            int _sz = this.values.length;
            for (int i = 0; i < _sz; ++i) {
                if (this.counts[i] < pMinCount) {
                    this.values[i] = Double.NaN;
                    continue;
                }
                _res = true;
            }
            return _res;
        }
    }
}

