/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.db;

import com.ngnms.apps.pmcollection.db.AvPmDataItem;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PmDataCollector {
    private static final Logger logger = Logger.getLogger(PmDataCollector.class);
    public static final int HOUR_IN_SECONDS = 3600;
    public static final int COLLECTION_PERIOD_SEC = 604800;
    public static final int[] RRA_COLLECTION_INTERVALS_SEC = new int[]{3600, 14400, 43200};
    public static final int[] RRA_COLLECTION_ROW_COUNT = new int[]{336, 336, 730};

    public abstract void storePmData(List<AvPmDataItem> var1);

    public abstract void cycleStarted();

    public abstract void cycleFinished();

    public static int getDisplayInterval(long pStartTime, long pEndTime) {
        long crtTime = System.currentTimeMillis();
        int level = PmDataCollector.getDisplayLevel(crtTime, pStartTime, pEndTime);
        if (0 == level) {
            return -1;
        }
        return RRA_COLLECTION_INTERVALS_SEC[level - 1];
    }

    protected static int getDisplayLevel(long pRefTime, long pStartTime, long pEndTime) {
        if (pStartTime < 0L || pEndTime < 0L || pStartTime >= pRefTime) {
            logger.info((Object)"getDisplayLevel() - invalid time, try to get data using level: 0");
            return 0;
        }
        logger.debug((Object)("getDisplayLevel() - Start Time is " + new Date(pStartTime) + " End Time is " + new Date(pEndTime)));
        long dataLenInSeconds = (pRefTime - pStartTime) / 1000L;
        logger.debug((Object)("getDisplayLevel() - dataLen in Seconds is: " + dataLenInSeconds));
        int level = 0;
        if (dataLenInSeconds > 604800L) {
            for (level = 1; level < RRA_COLLECTION_INTERVALS_SEC.length && dataLenInSeconds > (long)(RRA_COLLECTION_INTERVALS_SEC[level - 1] * RRA_COLLECTION_ROW_COUNT[level - 1]); ++level) {
            }
        }
        logger.info((Object)("getDisplayLevel() - get data using level: " + level));
        return level;
    }

    public static long getRoundTime(long pTime, int pIntervalInSeconds) {
        long interval = pIntervalInSeconds * 1000;
        long ZoneOffset = Calendar.getInstance().get(15);
        double crtZoneTime = pTime + ZoneOffset;
        long newZoneTime = Math.round(crtZoneTime / (double)interval) * interval;
        return newZoneTime - ZoneOffset;
    }
}

