/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance.db;

import org.snmp4j.smi.OID;

public class PmCollectionVariable {
    private String name;
    private String snmpOid;
    private int type;
    private OID oid;

    public PmCollectionVariable() {
    }

    public PmCollectionVariable(String pName, String pSnmpOid, int pType) {
        this.name = pName;
        this.snmpOid = pSnmpOid;
        this.type = pType;
    }

    public void setName(String pName) {
        this.name = pName;
    }

    public String getName() {
        return this.name;
    }

    public void setSnmpOid(String pSnmpOid) {
        this.snmpOid = pSnmpOid;
    }

    public String getSnmpOid() {
        if (this.snmpOid != null) {
            return this.snmpOid;
        }
        return this.oid != null ? this.oid.toString() : null;
    }

    public void setType(int pType) {
        this.type = pType;
    }

    public int getType() {
        return this.type;
    }

    public OID getOid() {
        return this.oid;
    }

    public void setOid(OID oid) {
        this.oid = oid;
    }

    public String toVarString() {
        StringBuffer sb = new StringBuffer();
        if (null != this.name) {
            sb.append(this.name.length());
            sb.append(':');
            sb.append(this.name);
        } else {
            sb.append(-1);
            sb.append(':');
        }
        sb.append(this.type);
        return sb.toString();
    }

    public static PmCollectionVariable fromVarString(String str) {
        PmCollectionVariable var = new PmCollectionVariable();
        int startPos = 0;
        int semiColonPos = str.indexOf(58, startPos);
        int len = Integer.parseInt(str.substring(startPos, semiColonPos));
        if (-1 != len) {
            startPos = semiColonPos + 1 + len;
            var.name = str.substring(semiColonPos + 1, startPos);
        } else {
            startPos = semiColonPos + 1;
            var.name = null;
        }
        var.type = Integer.parseInt(str.substring(startPos));
        return var;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.snmpOid == null ? 0 : this.snmpOid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PmCollectionVariable other = (PmCollectionVariable)obj;
        return !(this.snmpOid == null ? other.snmpOid != null : !this.snmpOid.equals(other.snmpOid));
    }
}

