/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance;

import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class PerformanceCollectionLookup {
    protected static final Version No_Version = VersionFactory.getInstance().createVersion("0_0_0_0", "_");
    protected TreeMap<String, List<String[]>> valuesLookup = null;

    public PerformanceCollectionLookup() {
        this.load();
    }

    protected abstract void load();

    protected abstract Version getMeVersion(Serializable var1);

    public String get(String section, Serializable me) {
        String categoryEntityKey = this.getCollectionEntityKey(section, me);
        return categoryEntityKey != null ? this.get(section, categoryEntityKey) : null;
    }

    public String getCollectionEntityKey(String section, Serializable me) {
        if (section == null) {
            throw new IllegalArgumentException("Section is null.");
        }
        Version softwareVersion = this.getMeVersion(me);
        return this.getCategoryEntityKey(section, me, softwareVersion);
    }

    protected String getCategoryEntityKey(String section, Serializable me, Version meVersion) {
        String meClassName = me.getClass().getName();
        if (((Object)meVersion).equals(No_Version)) {
            return meClassName;
        }
        List<String[]> sectionDatas = this.valuesLookup.get(section);
        TreeSet<Version> sectionVersions = new TreeSet<Version>();
        for (int i = 0; i < sectionDatas.size(); ++i) {
            String[] data = sectionDatas.get(i);
            if (!data[0].startsWith(meClassName)) continue;
            String strVersion = data[0].replaceFirst(meClassName, "");
            if (strVersion.length() > 0) {
                if (this.isVersionPattern(strVersion)) {
                    if (!this.matchVersion(strVersion, meVersion)) continue;
                    return meClassName + strVersion;
                }
                Version lineVersion = VersionFactory.getInstance().createVersion(strVersion, "_");
                if (((Object)meVersion).equals(lineVersion)) {
                    return meClassName + "_" + lineVersion.toShortString();
                }
                sectionVersions.add(lineVersion);
                continue;
            }
            sectionVersions.add(No_Version);
        }
        if (sectionVersions.size() == 0) {
            return null;
        }
        SortedSet<Version> lessSet = sectionVersions.headSet(meVersion);
        if (lessSet.size() == 0) {
            return null;
        }
        Version last = lessSet.last();
        return ((Object)No_Version).equals(last) ? meClassName : meClassName + "_" + last.toShortString();
    }

    private boolean isVersionPattern(String strVersion) {
        return strVersion.startsWith("<") && strVersion.endsWith(">");
    }

    private boolean matchVersion(String pattern, Version meVersion) {
        if (pattern.startsWith("<") && pattern.endsWith(">")) {
            String strVersion = pattern.substring(1, pattern.length() - 1);
            if (strVersion.equals("*")) {
                return true;
            }
            if (strVersion.startsWith("+")) {
                return meVersion.isOlderOrEqualWith(VersionFactory.getInstance().createVersion(strVersion.substring(1), "_"));
            }
            if (strVersion.endsWith("+")) {
                return meVersion.isNewerOrEqualWith(VersionFactory.getInstance().createVersion(strVersion.substring(0, strVersion.length() - 1), "_"));
            }
            StringTokenizer token = new StringTokenizer(strVersion, "~");
            int countTokens = token.countTokens();
            if (countTokens == 2) {
                Version minVersion = VersionFactory.getInstance().createVersion(token.nextToken(), "_");
                Version maxVersion = VersionFactory.getInstance().createVersion(token.nextToken(), "_");
                if (meVersion.isNewerOrEqualWith(minVersion) && meVersion.isOlderOrEqualWith(maxVersion)) {
                    return true;
                }
                throw new IllegalArgumentException("Version pattern is invalid");
            }
            token = new StringTokenizer(strVersion, "&");
            countTokens = token.countTokens();
            if (countTokens == 2) {
                Version version1 = VersionFactory.getInstance().createVersion(token.nextToken(), "_");
                Version version2 = VersionFactory.getInstance().createVersion(token.nextToken(), "_");
                if (meVersion.isEqualWith(version1) || meVersion.isEqualWith(version2)) {
                    return true;
                }
                throw new IllegalArgumentException("Version pattern is invalid. Only with 2 fixed versions comparision is supported for now.");
            }
        }
        throw new IllegalArgumentException("Version pattern is invalid");
    }

    public String get(String section) {
        String ret = null;
        List<String[]> sectionData = this.valuesLookup.get(section);
        if (null != sectionData && !sectionData.isEmpty()) {
            ret = sectionData.get(0)[1];
        }
        return ret;
    }

    public String get(String section, String meKey) {
        String ret = null;
        List<String[]> sectionData = this.valuesLookup.get(section);
        if (null != sectionData) {
            for (String[] line : sectionData) {
                if (!meKey.equals(line[0])) continue;
                ret = line[1];
                break;
            }
        }
        return ret;
    }

    protected void load(InputStream is) {
        this.valuesLookup = new TreeMap();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            List<String[]> crtSectionContent = null;
            String line = br.readLine();
            while (null != line) {
                if (0 != (line = line.trim()).length() && !line.startsWith("#")) {
                    if (line.startsWith("[") && line.endsWith("]")) {
                        String section = line.substring(1, line.length() - 1);
                        crtSectionContent = this.valuesLookup.get(section);
                        if (null == crtSectionContent) {
                            crtSectionContent = new ArrayList<String[]>();
                            this.valuesLookup.put(section, crtSectionContent);
                        }
                    } else {
                        int separatorIdx = line.indexOf(61);
                        if (-1 == separatorIdx) {
                            crtSectionContent.add(new String[]{line, ""});
                        } else {
                            crtSectionContent.add(new String[]{line.substring(0, separatorIdx), line.substring(separatorIdx + 1, line.length())});
                        }
                    }
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Lookup INITIALIZATION Exception: " + e.getMessage(), e);
        }
    }
}

