/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance;

import com.bwanms.performance.db.PmCollectionVariable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwPMCollectionItemDef")
public class PerformanceCollectionItemDef
implements Serializable {
    private long id;
    private String name;
    private String collKeysAsString;
    private String collVarsAsString;
    private int listPosition;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(length=2000)
    private String getCollVarsAsString() {
        return this.collVarsAsString;
    }

    private void setCollVarsAsString(String collVarsAsString) {
        this.collVarsAsString = collVarsAsString;
    }

    @Column(length=2000)
    private String getCollKeysAsString() {
        return this.collKeysAsString;
    }

    private void setCollKeysAsString(String collKeysAsString) {
        this.collKeysAsString = collKeysAsString;
    }

    public int getListPosition() {
        return this.listPosition;
    }

    public void setListPosition(int listPosition) {
        this.listPosition = listPosition;
    }

    @Transient
    public List<PmCollectionVariable> getVars() {
        return PerformanceCollectionItemDef.stringToPmVars(this.collVarsAsString);
    }

    public void setVars(List<PmCollectionVariable> pmCollVars) {
        this.collVarsAsString = PerformanceCollectionItemDef.pmVarsToString(pmCollVars);
    }

    @Transient
    public List<PmCollectionVariable> getKeys() {
        return PerformanceCollectionItemDef.stringToPmVars(this.collKeysAsString);
    }

    public void setKeys(List<PmCollectionVariable> pmCollVars) {
        this.collKeysAsString = PerformanceCollectionItemDef.pmVarsToString(pmCollVars);
    }

    private static List<PmCollectionVariable> stringToPmVars(String varsAsString) {
        if (null == varsAsString || "".equals(varsAsString)) {
            return null;
        }
        if (!varsAsString.startsWith("#")) {
            throw new RuntimeException("ERROR: varsAsString does not start with #");
        }
        String varListAsString = varsAsString.substring(1);
        List<String> stringList = PerformanceCollectionItemDef.stringListToList(varListAsString);
        ArrayList<PmCollectionVariable> ret = new ArrayList<PmCollectionVariable>(stringList.size());
        for (String pmVarAsString : stringList) {
            ret.add(PmCollectionVariable.fromVarString(pmVarAsString));
        }
        return ret;
    }

    private static String pmVarsToString(List<PmCollectionVariable> pmVars) {
        if (null == pmVars) {
            return "";
        }
        ArrayList<String> stringList = new ArrayList<String>(pmVars.size());
        for (PmCollectionVariable pmVar : pmVars) {
            stringList.add(pmVar.toVarString());
        }
        return "#" + PerformanceCollectionItemDef.stringListToString(stringList);
    }

    private static String stringListToString(List<String> valuesAsList) {
        StringBuffer sb = new StringBuffer();
        for (String value : valuesAsList) {
            sb.append(value.length());
            sb.append(':');
            sb.append(value);
        }
        return sb.toString();
    }

    private static List<String> stringListToList(String valuesAsString) {
        int len;
        Vector<String> valuesAsList = new Vector<String>();
        if (null == valuesAsString) {
            return valuesAsList;
        }
        for (int i = 0; i < valuesAsString.length(); i += len) {
            int semiColonIdx = valuesAsString.indexOf(58, i);
            len = new Integer(valuesAsString.substring(i, semiColonIdx));
            i = semiColonIdx + 1;
            valuesAsList.add(valuesAsString.substring(i, i + len));
        }
        return valuesAsList;
    }
}

