/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance;

import com.bwanms.model.Identifiable;
import com.bwanms.performance.PerformanceCollectionItemDef;
import com.bwanms.util.NameValuePair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwPMCollectionEntity")
public abstract class PerformanceCollectionEntity
implements Serializable {
    private static final Logger logger = Logger.getLogger(PerformanceCollectionEntity.class);
    private boolean isCollected;
    private List<PerformanceCollectionItemDef> counterDefs;
    private long id;

    @Transient
    public abstract Serializable getEntity();

    @Transient
    public long getEntityId() {
        Identifiable identifiable = (Identifiable)((Object)this.getEntity());
        return null != identifiable ? identifiable.getId() : 0L;
    }

    @Transient
    public abstract String getEntityName();

    @Transient
    public String getEntityFileName() {
        return this.getEntityName();
    }

    @Transient
    public NameValuePair[] getEntityAdditionalHeaderColumns() {
        return null;
    }

    public void initEntity() {
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isCollected() {
        return this.isCollected;
    }

    public void setCollected(boolean isCollected) {
        this.isCollected = isCollected;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="BwPmCollEntityItemDef_Assoc"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PerformanceCollectionItemDef> getCounterDefs() {
        return this.counterDefs;
    }

    public void setCounterDefs(List<PerformanceCollectionItemDef> counterDefs) {
        this.counterDefs = counterDefs;
    }

    @Transient
    public Serializable getCounters() {
        if (null == this.counterDefs) {
            return null;
        }
        ArrayList<Object[]> ret = new ArrayList<Object[]>(this.counterDefs.size());
        block0: for (int i = 0; i < this.counterDefs.size(); ++i) {
            for (PerformanceCollectionItemDef def : this.counterDefs) {
                if (def.getListPosition() != i) continue;
                Object[] weird = new Object[]{def.getName(), def.getKeys(), def.getVars()};
                ret.add(weird);
                continue block0;
            }
        }
        logger.debug((Object)("getCounters() - in size: " + this.counterDefs.size() + "  out size: " + ret.size()));
        return ret;
    }

    public void setCounters(Serializable counters) {
        List counterList = null != counters ? (List)((Object)counters) : new ArrayList();
        ArrayList<PerformanceCollectionItemDef> defs = new ArrayList<PerformanceCollectionItemDef>(counterList.size());
        for (int i = 0; i < counterList.size(); ++i) {
            Object[] weird = (Object[])counterList.get(i);
            PerformanceCollectionItemDef def = new PerformanceCollectionItemDef();
            def.setName((String)weird[0]);
            def.setKeys((List)weird[1]);
            def.setVars((List)weird[2]);
            def.setListPosition(i);
            defs.add(def);
        }
        logger.debug((Object)("setCounters() - in size: " + counterList.size() + "  out size: " + defs.size()));
        if (null != this.counterDefs) {
            this.counterDefs.clear();
            this.counterDefs.addAll(defs);
        } else {
            this.counterDefs = defs;
        }
    }
}

