/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance;

import com.bwanms.model.ManagementInterface;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.performance.PerformanceCollectionActiveTaskHelper;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.performance.PerformanceCollectionLookup;
import com.bwanms.performance.db.PmCollectionVariable;
import com.ngnms.apps.pmcollection.db.AvPmDataItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PerformanceCollectionActiveEntity {
    public static final String TBL_NAME_NONE = "{NONE}";
    private static final Logger logger = Logger.getLogger(PerformanceCollectionActiveEntity.class);
    protected Long entityID;
    protected String entityUID;
    protected String entityName;
    protected String entityType;
    protected String groupUID;
    protected boolean managedElement;
    protected String elementUID;
    protected String elementName;
    protected String elementType;
    protected String swVersion;
    protected String ipAddress;
    protected int port;
    protected String community;
    protected int snmpVersion;
    protected int snmpTimeout = -1;
    protected int snmpRetries = 0;
    private int maxSizeResponsePDU = 65535;
    protected List<Object[]> counters;
    protected int requestInterval = 0;
    protected TreeMap<String, double[]> lastCollectedVars = new TreeMap();
    protected TreeMap<String, Long> lastCollectedTimes = new TreeMap();
    protected boolean collectable;
    private Target target;

    public void init(PerformanceCollectionEntity pmEntity) {
        this.entityID = pmEntity.getEntityId();
        this.counters = (List)((Object)pmEntity.getCounters());
        this.collectable = true;
        SNMPManagementInterface mi = (SNMPManagementInterface)this.getManagementInterface(pmEntity.getEntity());
        if (null != mi) {
            this.ipAddress = mi.getIp();
            this.port = mi.getPort();
            this.community = mi.getReadCommunity();
            this.snmpVersion = mi.getVersion();
            this.target = this.createTarget();
        } else {
            this.target = null;
            this.collectable = false;
        }
        this.setEntitySpecificParameters(pmEntity.getEntity());
    }

    protected Target createTarget() {
        int snmpVersion = this.getSnmpVersion();
        if (snmpVersion == 0 || snmpVersion == 1) {
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(this.community));
            target.setVersion(this.getSnmpVersion());
            target.setAddress(this.getAddress(this.ipAddress));
            target.setRetries(this.snmpRetries);
            target.setMaxSizeRequestPDU(this.maxSizeResponsePDU);
            return target;
        }
        if (snmpVersion == 3) {
            throw new UnsupportedOperationException("SNMP v3 not supported yet.");
        }
        return null;
    }

    protected abstract ManagementInterface getManagementInterface(Serializable var1);

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getGroupUID() {
        return this.groupUID;
    }

    public String getEntityUID() {
        return this.entityUID;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public boolean isManagedElement() {
        return this.managedElement;
    }

    public String getElementUID() {
        return this.elementUID;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getSwVersion() {
        return this.swVersion;
    }

    protected abstract void setEntitySpecificParameters(Serializable var1);

    public int getSnmpVersion() {
        return this.snmpVersion;
    }

    public void setSnmpRetries(int pSnmpRetries) {
        this.snmpRetries = pSnmpRetries;
    }

    public void setSnmpTimeout(int pSnmpTimeout) {
        this.snmpTimeout = pSnmpTimeout;
    }

    public boolean isCollectable() {
        return this.collectable;
    }

    public List<Object[]> getCounters() {
        return this.counters;
    }

    void setCounters(List<Object[]> counters) {
        this.counters = counters;
    }

    public Target getTarget() {
        return this.target;
    }

    public Long getEntityID() {
        return this.entityID;
    }

    public List<PDU> getSnmpRequests() {
        ArrayList<PDU> requests = new ArrayList<PDU>();
        if (!this.isCollectable()) {
            return requests;
        }
        for (Object[] objects : this.counters) {
            String category = (String)objects[0];
            List keys = (List)objects[1];
            List vars = (List)objects[2];
            Object request = this.target.getVersion() == 0 ? new PDUv1() : new PDU();
            request.setType(null == keys ? -96 : -95);
            logger.debug((Object)String.format("Set type %s on version %s category %s", PDU.getTypeString((int)request.getType()), this.getVersionString(this.target.getVersion()), category));
            for (PmCollectionVariable variable : vars) {
                request.add(new VariableBinding(variable.getOid()));
            }
            requests.add((PDU)request);
        }
        return requests;
    }

    public List<AvPmDataItem> processResponse(PDU req, PDU resp, int countersIndex, HashMap<Integer32, Long> timeStamps) {
        ArrayList<AvPmDataItem> dataItems = new ArrayList<AvPmDataItem>();
        try {
            boolean success;
            logger.debug((Object)String.format("start process response %s", resp.toString()));
            boolean bl = success = resp.getErrorStatus() == 0;
            if (!success) {
                logger.debug((Object)"=============");
                logger.debug((Object)String.format("PDU response with error: %B.", !success));
                logger.debug((Object)"=============");
            }
            Object[] crtRow = this.getCounters().get(countersIndex);
            String _name = (String)crtRow[0];
            List _keys = (List)crtRow[1];
            List _cvs = (List)crtRow[2];
            String rowID = this.processRowID(req, resp, success, _name, _keys, _cvs);
            logger.debug((Object)String.format("ROWID %s", rowID));
            if (null == rowID) {
                return dataItems;
            }
            long lastCollectedTime = 0L;
            Long long1 = this.lastCollectedTimes.get(rowID);
            logger.debug((Object)String.format("Last collected time %s %d", rowID, long1));
            if (long1 != null) {
                lastCollectedTime = long1;
            }
            long newCollectedTime = timeStamps.get(req.getRequestID());
            logger.debug((Object)String.format("New collected time for request id %s : %d", req.getRequestID().toString(), newCollectedTime));
            double deltaInSeconds = (double)(newCollectedTime - lastCollectedTime) / 1000.0;
            logger.debug((Object)String.format("RowID = %s, new collected time = %TT, last collected time = %TT.", rowID, new Date(newCollectedTime), new Date(lastCollectedTime)));
            if (deltaInSeconds <= 0.0) {
                logger.warn((Object)"Collection time must be after Last Collection Time!!! The response process will be skipped.");
                throw new IllegalArgumentException("Invalid Collection Time: " + new Date(newCollectedTime) + " OLD TIME IS " + new Date(lastCollectedTime) + " ROWID is " + rowID);
            }
            logger.debug((Object)String.format("time delta %s %f", Double.toString(deltaInSeconds), deltaInSeconds));
            double[] values = this.processRowData(resp, success, req.getType() == -95, _name, _keys, _cvs);
            double[] lastValues = this.lastCollectedVars.get(rowID);
            if (null == lastValues) {
                lastValues = new double[]{};
            }
            double[] retValues = this.processRowValues(values, lastValues, _cvs, deltaInSeconds);
            String[] names = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                PmCollectionVariable _cv = (PmCollectionVariable)_cvs.get(i);
                names[i] = _cv.getName();
            }
            AvPmDataItem pmDataItem = new AvPmDataItem(success, String.valueOf(this.getEntityID()), rowID, newCollectedTime, names, retValues);
            this.lastCollectedTimes.put(rowID, new Long(newCollectedTime));
            this.lastCollectedVars.put(rowID, values);
            logger.debug((Object)String.format("added data item %s", pmDataItem.toString()));
            dataItems.add(pmDataItem);
        }
        catch (Throwable e) {
            logger.error((Object)("Response processing error " + e.getMessage()), e);
        }
        return dataItems;
    }

    protected double[] processRowValues(double[] values, double[] lastValues, List<PmCollectionVariable> _cvs, double deltaInSeconds) {
        logger.debug((Object)"starting");
        double[] retValues = new double[values.length];
        System.arraycopy(values, 0, retValues, 0, values.length);
        for (int i = 0; i < values.length; ++i) {
            PmCollectionVariable _cv = _cvs.get(i);
            if (0 == (2 & _cv.getType())) continue;
            if (deltaInSeconds > 0.0 && i < lastValues.length && !Double.isNaN(values[i]) && !Double.isNaN(lastValues[i]) && lastValues[i] <= values[i]) {
                long processedValue = Math.round((values[i] - lastValues[i]) / deltaInSeconds);
                logger.debug((Object)String.format("I = %d: Value = %f, last value = %f, processed value = %d", i, values[i], lastValues[i], processedValue));
                retValues[i] = processedValue;
                continue;
            }
            logger.debug((Object)String.format("Unsatisfied conditions for Delta, lastValues and values. The applied default value is [Double.Nan]: %f", Double.NaN));
            retValues[i] = Double.NaN;
        }
        logger.debug((Object)"END");
        return retValues;
    }

    protected double[] processRowData(PDU response, boolean success, boolean isGetNext, String pName, List<PmCollectionVariable> pKeys, List<PmCollectionVariable> pVars) {
        logger.debug((Object)String.format("Starting processRowData (PDU response with error: %B )", !success));
        int size = pVars.size();
        double[] ret = new double[size];
        Arrays.fill(ret, Double.NaN);
        if (!success) {
            return ret;
        }
        logger.debug((Object)("response.getVariableBindings() " + size));
        Vector variableBindings = response.getVariableBindings();
        for (int i = 0; i < size; ++i) {
            PmCollectionVariable cv = pVars.get(i);
            logger.debug((Object)String.format("PmCollectionVariable %s", cv.toVarString()));
            if (-1 != cv.getType()) {
                Variable data = this.getCVData(cv, variableBindings, isGetNext);
                logger.debug((Object)String.format("data %s", data != null ? data.toString() : "null"));
                if (data == null) continue;
                logger.debug((Object)String.format("process data: %s %s", data.getSyntaxString(), data.toString()));
                int syntax = data.getSyntax();
                switch (syntax) {
                    case 2: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 70: {
                        ret[i] = data.toLong();
                        break;
                    }
                    case 4: {
                        try {
                            ret[i] = Double.parseDouble(data.toString());
                        }
                        catch (NumberFormatException e) {
                            logger.error((Object)String.format("Could not parse data as double: %s", data.toString()));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsuported data type: " + data.getSyntaxString());
                    }
                }
                continue;
            }
            logger.debug((Object)("cv with Name: [" + cv.getName() + "]  was DELETED."));
        }
        logger.debug((Object)"END");
        return ret;
    }

    protected String processRowID(PDU req, PDU resp, boolean success, String pName, List<PmCollectionVariable> pKeys, List<PmCollectionVariable> pVars) {
        StringBuilder builder = new StringBuilder();
        builder.append(pName);
        if (success && req.getType() == -95) {
            Vector variableBindings = resp.getVariableBindings();
            if (pKeys.size() == 0 && variableBindings.size() > 0) {
                PmCollectionVariable pmVar = pVars.get(0);
                OID oidBase = pmVar.getOid();
                oidBase = this.removeLastZero(oidBase);
                OID firstOID = ((VariableBinding)variableBindings.get(0)).getOid();
                if (!firstOID.startsWith(oidBase)) {
                    throw new IllegalArgumentException("INVALID OID: " + firstOID + "    should start with: " + pmVar.getOid().toString());
                }
                OID instOID = new OID(firstOID.getValue(), oidBase.size(), firstOID.size() - oidBase.size());
                String inst = instOID.toString();
                builder.append("::");
                builder.append(inst);
                logger.debug((Object)("processRowID - pName = " + pName + "  inst = " + inst));
            }
            for (int i = 0; i < pKeys.size(); ++i) {
                PmCollectionVariable _cv = pKeys.get(i);
                Variable _data = this.getCVData(_cv, variableBindings, true);
                logger.debug((Object)String.format("data %s", _data == null ? "null" : _data.toString()));
                if (null != _data) {
                    builder.append("::");
                    builder.append(_data);
                }
                logger.debug((Object)("processRowID - pName = " + pName + "  data = " + _data));
            }
        }
        return builder.toString();
    }

    protected Variable getCVData(PmCollectionVariable _cv, Vector<VariableBinding> variableBindings, boolean isTableRow) {
        OID oid = _cv.getOid();
        logger.debug((Object)("starting oid.size " + oid.size()));
        if (oid.size() > 0) {
            VariableBinding vb = this.findVB(variableBindings, oid, isTableRow);
            logger.debug((Object)("vb " + vb));
            if (vb != null) {
                return vb.getVariable();
            }
            logger.debug((Object)("cv with Name: [" + _cv.getName() + "]  is NOT FOUND!!!"));
            return null;
        }
        return null;
    }

    private VariableBinding findVB(Vector<VariableBinding> variableBindings, OID oid, boolean isTableRow) {
        logger.debug((Object)("starting isTableRow " + isTableRow));
        if (isTableRow) {
            oid = this.removeLastZero(oid);
            for (VariableBinding vb : variableBindings) {
                if (!vb.getOid().startsWith(oid)) continue;
                return vb;
            }
        } else {
            for (VariableBinding vb : variableBindings) {
                if (!oid.equals((Object)vb.getOid())) continue;
                return vb;
            }
        }
        return null;
    }

    private OID removeLastZero(OID oid) {
        if (oid.last() == 0) {
            OID clone = (OID)oid.clone();
            clone.removeLast();
            return clone;
        }
        return oid;
    }

    private String getVersionString(int version) {
        switch (version) {
            case 0: {
                return "VERSION 1";
            }
            case 1: {
                return "VERSION 2";
            }
            case 3: {
                return "VERSION 3";
            }
        }
        throw new IllegalArgumentException("Unknown version " + version);
    }

    private Address getAddress(String ip) {
        String protocol = "udp";
        StringBuilder builder = new StringBuilder();
        builder.append(ip).append("/").append(this.port);
        String transportAddress = builder.toString();
        if (protocol.equalsIgnoreCase("udp")) {
            return new UdpAddress(transportAddress);
        }
        if (protocol.equalsIgnoreCase("tcp")) {
            return new TcpAddress(transportAddress);
        }
        throw new IllegalArgumentException("Unknown transport for protocol " + protocol);
    }

    public boolean updateCounterList(PerformanceCollectionActiveTaskHelper helper, Serializable entity, String[] pCategories) {
        Vector<Object[]> newCounters = new Vector();
        try {
            newCounters = this.getCollectionProps(helper, entity, pCategories);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TABLES list size is: " + newCounters.size()));
                for (int t = 0; t < newCounters.size(); ++t) {
                    Object[] prop = (Object[])newCounters.get(t);
                    logger.debug((Object)("TABLE with name: " + prop[0] + "  keysSize: " + (null != prop[1] ? ((List)prop[1]).size() : -1) + "  varsSize: " + ((List)prop[2]).size()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.updateCounterList(newCounters);
    }

    public synchronized boolean updateCounterList(List<Object[]> pNewCounters) {
        boolean ret = false;
        logger.debug((Object)("updateCounterList before: " + (null != this.counters ? this.counters.size() : 0)));
        if (null == this.counters || PerformanceCollectionActiveEntity.updateCountersList(this.counters, pNewCounters)) {
            if (null == this.counters) {
                this.counters = pNewCounters;
            }
            ret = true;
        } else {
            ret = false;
        }
        logger.debug((Object)("updateCounterList after : " + this.counters.size()));
        return ret;
    }

    private List<Object[]> getCollectionProps(PerformanceCollectionActiveTaskHelper helper, Serializable managedEntity, String[] pCategories) throws Exception {
        HashMap<String, Object[]> ret = new HashMap<String, Object[]>();
        PerformanceCollectionLookup lookup = helper.getLookup();
        for (int i = 0; i < pCategories.length; ++i) {
            String _category = pCategories[i];
            String _categoryProps = lookup.get(_category, managedEntity);
            if (null == _categoryProps) continue;
            logger.debug((Object)("Category Properties String: [" + _categoryProps + "]"));
            StringTokenizer _st = new StringTokenizer(_categoryProps, "+");
            while (_st.hasMoreTokens()) {
                String _prop = _st.nextToken().trim();
                StringTokenizer _tblst = new StringTokenizer(_prop, ":");
                int _tokenCount = _tblst.countTokens();
                boolean bTblRow = _tokenCount > 2;
                String _tblName = _tokenCount > 1 ? _tblst.nextToken() : TBL_NAME_NONE;
                Object[] _crtTable = (Object[])ret.get(_tblName);
                if (null == _crtTable) {
                    logger.debug((Object)("NEW TABLE: [" + _tblName + "]  tokenCount: " + _tokenCount));
                    _crtTable = new Object[]{_tblName, bTblRow ? new Vector() : null, new Vector()};
                    ret.put(_tblName, _crtTable);
                }
                if (bTblRow) {
                    String _keys = _tblst.nextToken();
                    logger.debug((Object)("KEYS: [" + _keys + "]"));
                    if (!_keys.equals(TBL_NAME_NONE)) {
                        StringTokenizer _keysst = new StringTokenizer(_keys, "|");
                        while (_keysst.hasMoreTokens()) {
                            String _keyprop = _keysst.nextToken();
                            PmCollectionVariable _cv = this.getPmCollectionVar(_keyprop, _keyprop, -1, lookup);
                            if (null == _cv) continue;
                            ((Vector)_crtTable[1]).add(_cv);
                        }
                    }
                }
                String _cvs = _tblst.nextToken();
                logger.debug((Object)("CVS: [" + _cvs + "]"));
                StringTokenizer _cvsst = new StringTokenizer(_cvs, "|");
                while (_cvsst.hasMoreTokens()) {
                    int _type;
                    String _cvprop = _cvsst.nextToken();
                    int pos = _cvprop.indexOf(44);
                    String _propName = -1 != pos ? _cvprop.substring(0, pos) : _cvprop;
                    PmCollectionVariable _cv = this.getPmCollectionVar(_propName, _propName, _type = -1 == pos ? -1 : Integer.parseInt(_cvprop.substring(1 + pos)), lookup);
                    if (null == _cv) continue;
                    ((Vector)_crtTable[2]).add(_cv);
                }
            }
        }
        return new Vector<Object[]>(ret.values());
    }

    protected PmCollectionVariable getPmCollectionVar(String pName, String snmpName, int pType, PerformanceCollectionLookup lookup) throws Exception {
        logger.debug((Object)("getPmCollectionVar() - " + pName + ", " + snmpName + ", " + pType));
        int instPos = snmpName.indexOf(46);
        String snmpAttrName = -1 != instPos ? snmpName.substring(0, instPos) : snmpName;
        String snmpAttrInst = -1 != instPos ? snmpName.substring(instPos) : "";
        String snmpVar = lookup.get("_mib_names_", snmpAttrName);
        if (null == snmpVar) {
            logger.debug((Object)("****** getPmCollectionVar() - snmpAttrName not found: " + snmpAttrName));
            return null;
        }
        int typePos = snmpVar.indexOf(44);
        String mibOid = snmpVar.substring(0, typePos);
        int mibType = Integer.parseInt(snmpVar.substring(typePos + 1));
        PmCollectionVariable cv = new PmCollectionVariable();
        cv.setName(pName);
        cv.setOid(new OID(mibOid + snmpAttrInst));
        cv.setType(-1 != pType ? pType : mibType);
        return cv;
    }

    private static boolean updateCountersList(List pCrtCounters, List pNewCounters) {
        boolean bRowFound;
        boolean ret = false;
        for (Object[] newRow : pNewCounters) {
            bRowFound = false;
            for (Object[] crtRow : pCrtCounters) {
                int i;
                if (!newRow[0].equals(crtRow[0])) continue;
                bRowFound = true;
                List crtRowVars = (List)crtRow[2];
                List newRowVars = (List)newRow[2];
                for (i = 0; i < crtRowVars.size(); ++i) {
                    PmCollectionVariable _ccv = (PmCollectionVariable)crtRowVars.get(i);
                    PmCollectionVariable _ncv = PerformanceCollectionActiveEntity.findCollVar(newRowVars, _ccv);
                    if (null == _ncv && -1 != _ccv.getType()) {
                        _ccv.setType(-1);
                        ret = true;
                        continue;
                    }
                    if (null == _ncv) continue;
                    _ccv.setOid(_ncv.getOid());
                }
                for (i = 0; i < newRowVars.size(); ++i) {
                    PmCollectionVariable _ncv = (PmCollectionVariable)newRowVars.get(i);
                    PmCollectionVariable _ccv = PerformanceCollectionActiveEntity.findCollVar(crtRowVars, _ncv);
                    if (null == _ccv) {
                        crtRowVars.add(_ncv);
                        ret = true;
                        continue;
                    }
                    if (-1 != _ccv.getType()) continue;
                    _ccv.setType(_ncv.getType());
                    _ccv.setName(_ncv.getName());
                    _ccv.setOid(_ncv.getOid());
                    ret = true;
                }
                crtRow[1] = newRow[1];
                break;
            }
            if (bRowFound) continue;
            pCrtCounters.add(newRow);
            ret = true;
            logger.debug((Object)("updateCountersList() -   added Row: [" + newRow[0] + "]"));
        }
        Iterator it = pCrtCounters.iterator();
        while (it.hasNext()) {
            Object[] crtRow = (Object[])it.next();
            bRowFound = false;
            for (Object[] newRow : pNewCounters) {
                if (!crtRow[0].equals(newRow[0])) continue;
                bRowFound = true;
                break;
            }
            if (bRowFound) continue;
            it.remove();
            ret = true;
            logger.debug((Object)("updateCountersList() - deleted Row: [" + crtRow[0] + "]"));
        }
        logger.debug((Object)("updateCountersList() - Changed Status is: [" + ret + "]"));
        return ret;
    }

    private static PmCollectionVariable findCollVar(List pCollVars, PmCollectionVariable pVar) {
        for (PmCollectionVariable _cv : pCollVars) {
            if (!_cv.getName().equals(pVar.getName())) continue;
            return _cv;
        }
        return null;
    }
}

