/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance;

import com.bwanms.tasks.pmcollection.MultipleEntityPMCollectionFactory;
import com.bwanms.tasks.pmcollection.PMCollectionFactory;
import com.bwanms.tasks.pmcollection.SingleEntityPMCollectionFactory;
import com.bwanms.util.SystemPropertyUtil;
import com.bwanms.util.archive.ArchiveException;
import com.bwanms.util.archive.DefaultArchiveFactory;
import com.bwanms.util.archive.spi.ArchiveFactory;
import com.bwanms.util.marshalling.MarshallingException;
import com.bwanms.util.marshalling.SimpleJAXBMarshallingFactory;
import com.bwanms.util.marshalling.spi.MarshallingFactory;
import org.apache.log4j.Logger;

public class PMCollectionFactoriesProvider {
    private static final Logger LOG = Logger.getLogger(PMCollectionFactoriesProvider.class);
    public static final PMCollectionFactoriesProvider INSTANCE = new PMCollectionFactoriesProvider();

    private PMCollectionFactoriesProvider() {
    }

    public synchronized ArchiveFactory getArchiveFactory() {
        String archiveFactoryProp = System.getProperty("astar.ngnms.utils.archiveFactory");
        if (archiveFactoryProp == null) {
            return new DefaultArchiveFactory();
        }
        try {
            Object archiveFac = Class.forName(archiveFactoryProp).newInstance();
            if (!(archiveFac instanceof ArchiveFactory)) {
                String excMsg = "Invalid archive factory class def";
                LOG.error((Object)"Invalid archive factory class def");
                throw new ArchiveException("Invalid archive factory class def");
            }
            return (ArchiveFactory)archiveFac;
        }
        catch (Exception ex) {
            String excMsg = String.format("Can't create the archive factory. The source exception message is: %s", ex.getMessage());
            LOG.error((Object)excMsg, (Throwable)ex);
            throw new ArchiveException(excMsg, ex);
        }
    }

    public synchronized MarshallingFactory getMarshallingFactory() {
        String marshallingFactoryProp = System.getProperty("com.bwanms.pmcollection.marshallingFactory");
        if (marshallingFactoryProp == null || "".equals(marshallingFactoryProp)) {
            return new SimpleJAXBMarshallingFactory();
        }
        try {
            Object marshallingFact = Class.forName(marshallingFactoryProp).newInstance();
            if (!(marshallingFact instanceof MarshallingFactory)) {
                String excMsg = "Invalid marshalling factory class def";
                LOG.error((Object)"Invalid marshalling factory class def");
                throw new MarshallingException("Invalid marshalling factory class def");
            }
            return (MarshallingFactory)marshallingFact;
        }
        catch (Exception ex) {
            String excMsg = String.format("Can't create the marshalling factory. The source exception message is: %s", ex.getMessage());
            LOG.error((Object)excMsg, (Throwable)ex);
            throw new MarshallingException(excMsg, ex);
        }
    }

    public synchronized PMCollectionFactory getPMCollectionFactory() {
        String groupingStrategy = SystemPropertyUtil.getString("com.bwanms.pmcollection.groupingStrategy", "multiple");
        if ("single".equalsIgnoreCase(groupingStrategy)) {
            return new SingleEntityPMCollectionFactory();
        }
        if ("multiple".equalsIgnoreCase(groupingStrategy)) {
            return new MultipleEntityPMCollectionFactory();
        }
        throw new IllegalArgumentException("Illegal value for \"com.bwanms.pmcollection.groupingStrategy\" property");
    }
}

