/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.performance;

import com.bwanms.performance.IPerformanceCounterFilter;
import com.bwanms.performance.PerformanceCollectionLookup;
import com.bwanms.performance.PerformanceCollectionTaskHandler;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtension;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMCollectionEntityTypeUtil {
    private static Map<String, Class> perfEntityTypes;
    private static Map<String, Class> perfTaskHandlers;
    private static Map<String, Class> perfTaskLookup;
    private static Map<String, Class> perfTaskEntityHandlers;
    private static Map<String, String> perfTaskProductLines;
    private static Map<String, IPerformanceCounterFilter> perfTaskCounterFilters;

    private static void putCounterFilter(String name, String counterFilterClassName) {
        if (name != null && counterFilterClassName != null) {
            IPerformanceCounterFilter handlerInstance = null;
            try {
                Class<?> handlerClass = Class.forName(counterFilterClassName);
                handlerInstance = (IPerformanceCounterFilter)handlerClass.newInstance();
                perfTaskCounterFilters.put(name, handlerInstance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> getAvailableEntityTypes() {
        return new ArrayList<String>(perfEntityTypes.keySet());
    }

    public static PerformanceCollectionTaskHandler createTaskHandler(String entityType) {
        PerformanceCollectionTaskHandler handlerInstance = null;
        try {
            Class handlerClass = PMCollectionEntityTypeUtil.getTaskTypeHandlerClassByType(entityType);
            handlerInstance = (PerformanceCollectionTaskHandler)handlerClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handlerInstance;
    }

    public static Class getTaskClassByType(String taskType) {
        throw new RuntimeException("Not yet implemented");
    }

    public static String getTaskTypeByClass(Class taskClass) {
        throw new RuntimeException("Not yet implemented");
    }

    public static Class getTaskTypeHandlerClassByType(String entityType) {
        return perfTaskHandlers.get(entityType);
    }

    public static Class getTaskLookupClassByType(String entityType) {
        return perfTaskLookup.get(entityType);
    }

    public static Class getTaskEntityHandlerClassByType(String taskType) {
        return perfTaskEntityHandlers.get(taskType);
    }

    public static String getTaskProductLineByType(String taskType) {
        return perfTaskProductLines.get(taskType);
    }

    public static PerformanceCollectionLookup getLookupByEntityType(String entityType) {
        PerformanceCollectionLookup lookupInstance = null;
        try {
            Class lookupClass = PMCollectionEntityTypeUtil.getTaskLookupClassByType(entityType);
            lookupInstance = (PerformanceCollectionLookup)lookupClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lookupInstance;
    }

    public static IPerformanceCounterFilter getPerformanceCounterFilter(String taskType) {
        return perfTaskCounterFilters.get(taskType);
    }

    static {
        IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
        IExtensionPoint taskTypesExtensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.pmcollection.entityTypes");
        IExtension[] extensions = taskTypesExtensionPoint.getExtensions();
        perfEntityTypes = new HashMap<String, Class>();
        perfTaskHandlers = new HashMap<String, Class>();
        perfTaskLookup = new HashMap<String, Class>();
        perfTaskEntityHandlers = new HashMap<String, Class>();
        perfTaskProductLines = new HashMap<String, String>();
        perfTaskCounterFilters = new HashMap<String, IPerformanceCounterFilter>();
        for (IExtension extension : extensions) {
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            for (int i = 0; i < configElements.length; ++i) {
                try {
                    String name = configElements[i].getAttribute("name");
                    perfEntityTypes.put(name, Class.forName(configElements[i].getAttribute("class")));
                    perfTaskHandlers.put(name, Class.forName(configElements[i].getAttribute("handlerClass")));
                    perfTaskLookup.put(name, Class.forName(configElements[i].getAttribute("lookupClass")));
                    perfTaskEntityHandlers.put(name, Class.forName(configElements[i].getAttribute("entityHandlerClass")));
                    perfTaskProductLines.put(name, configElements[i].getAttribute("productLine"));
                    PMCollectionEntityTypeUtil.putCounterFilter(name, configElements[i].getAttribute("counterFilterClass"));
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
            }
        }
    }
}

