/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.visualization;

import com.bwanms.model.visualization.LogicalMapLinkEndPoint;
import com.bwanms.model.visualization.Visualization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.validator.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwLogicalMap")
public class LogicalMap
extends Visualization {
    private List<LogicalMapLinkEndPoint> linkEndPoints;
    private byte[] background;
    public static final int MAXIMUM_BACKGROUND_SIZE = 512000;

    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="map_Id")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<LogicalMapLinkEndPoint> getLinkEndPoints() {
        if (this.linkEndPoints == null) {
            this.linkEndPoints = new ArrayList<LogicalMapLinkEndPoint>();
        }
        return this.linkEndPoints;
    }

    public void setLinkEndPoints(List<LogicalMapLinkEndPoint> equipment) {
        this.linkEndPoints = equipment;
    }

    public void synchronizeLinkEndPoints(Collection<LogicalMapLinkEndPoint> linkEndPoints) {
        this.getLinkEndPoints().clear();
        this.getLinkEndPoints().addAll(linkEndPoints);
    }

    @Lob(fetch=FetchType.LAZY)
    @Length(max=512000)
    public byte[] getBackground() {
        return this.background;
    }

    public void setBackground(byte[] background) {
        this.background = background;
    }
}

