/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.topology;

import com.bwanms.model.topology.TopologyAdapter;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TopologyAdapters {
    private static final Logger logger = Logger.getLogger(TopologyAdapters.class);
    private static TopologyAdapters instance;
    private HashMap<String, TopologyAdapter> adapters;

    private static synchronized TopologyAdapters instance() {
        if (instance == null) {
            instance = new TopologyAdapters();
        }
        return instance;
    }

    public static TopologyAdapter getTopologyAdapter(String className) {
        return TopologyAdapters.instance().getTopologyAdapterImpl(className);
    }

    public static boolean isSupported(String className) {
        return instance.isSupportedImpl(className);
    }

    private TopologyAdapters() {
        this.configure();
    }

    private void configure() {
        logger.info((Object)"Initializing TopologyAdapters...");
        this.adapters = new HashMap();
        try {
            IConfigurationElement[] elements;
            IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.topologyAdapters");
            for (IConfigurationElement element : elements = extensionPoint.getConfigurationElements()) {
                try {
                    TopologyAdapter adapter = (TopologyAdapter)element.createExecutableExtension("class");
                    String targetClass = element.getAttribute("targetClass");
                    this.adapters.put(targetClass, adapter);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger.info((Object)"TopologyAdapters initialized");
    }

    public TopologyAdapter getTopologyAdapterImpl(String className) {
        return this.adapters.get(className);
    }

    public boolean isSupportedImpl(String className) {
        return this.adapters.containsKey(className);
    }
}

