/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.topology;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.Locatable;
import com.bwanms.model.Location;
import com.bwanms.model.ObjectID;
import com.bwanms.model.topology.Link;
import com.bwanms.model.topology.Node;
import com.bwanms.model.topology.TopologyAdapter;
import com.bwanms.model.topology.TopologyAdapters;
import com.bwanms.persistence.Datastore;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationTopologyAdapter
implements TopologyAdapter<Location> {
    @Override
    public Node getVertex(Location location) {
        ArrayList<Link> inboundLinks = new ArrayList<Link>();
        for (Location child : location.getChildren()) {
            inboundLinks.add(new Link(new ObjectID(child), new ObjectID(location)));
        }
        List locatables = Datastore.session().createQuery("from " + Locatable.class.getName() + " as l where l.location=:location").setEntity("location", (Object)location).list();
        for (Locatable locatable : locatables) {
            if (!TopologyAdapters.isSupported(locatable.getClass().getName())) continue;
            inboundLinks.add(new Link(new ObjectID(locatable), new ObjectID(location)));
        }
        ArrayList<Link> outboundLinks = new ArrayList<Link>();
        if (location.getParent() != null) {
            outboundLinks.add(new Link(new ObjectID(location), new ObjectID(location.getParent())));
        }
        return new LocationNode(new ObjectID(location), location.getName(), true, location.getAlarmState(), outboundLinks, inboundLinks, new String[0][], location.getIconName());
    }

    @Override
    public List getOutboundLinkEndPoints(Location location) {
        ArrayList<Location> ret = new ArrayList<Location>();
        if (location.getParent() != null) {
            ret.add(location.getParent());
        }
        return ret;
    }

    @Override
    public List<Object> getAlarmPropagationLinks(Location object) {
        return this.getOutboundLinkEndPoints(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocationNode
    extends Node {
        private String[][] details;

        public LocationNode(ObjectID objectID, String name, boolean logical, int alarmState, List<Link> outboundLinks, List<Link> inboundLinks, String[][] details, String iconName) {
            super(objectID, name, logical, alarmState, outboundLinks, inboundLinks, iconName);
            this.details = details;
        }

        @Override
        public String[][] getDetails() {
            Internationalizer i18n = Internationalizer.getInternationalizer(LocationTopologyAdapter.class);
            String[][] ret = new String[this.details.length][2];
            for (int i = 0; i < ret.length; ++i) {
                ret[i][0] = i18n.translateString(this.details[i][0]);
                ret[i][1] = this.details[i][1];
            }
            return ret;
        }
    }
}

