/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.task;

import com.bwanms.model.Identifiable;
import com.bwanms.model.ManagedTaskWeakAssociation;
import com.bwanms.model.Task;
import com.bwanms.model.TaskExecutor;
import com.bwanms.performance.PerformanceCollectionEntity;
import com.bwanms.performance.PerformanceCollectionTaskHandler;
import com.bwanms.tasks.pmcollection.BaseTimeStrategyFactory;
import com.bwanms.tasks.pmcollection.PMCollectionTaskExecutor;
import com.bwanms.util.SystemPropertyUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwPMCollectionTask")
public class PerformanceCollectionGenericTask
extends Task {
    private static final long serialVersionUID = -1256747061689177735L;
    public static final int REP_PERIOD = 900000;
    public static final int CATEGORY_CAPACITY = 1;
    public static final int CATEGORY_TRAFFIC = 2;
    public static final int CATEGORY_RADIO = 3;
    public static final int STORAGE_RAW = 1;
    public static final int STORAGE_FILE = 2;
    public static final int STORAGE_BOTH = 3;
    public static String DEFAULT_EXPORT_FOLDER = System.getenv("OWARE_USER_ROOT") + File.separator + "filesystem" + File.separator + "export";
    private List<PerformanceCollectionEntity> entities;
    private String entityType;
    private Date createdDate;
    private int pollingInterval;
    private String[] counters;
    private int countersCategory;
    private int storage;
    private boolean autoExport;
    private List<ManagedTaskWeakAssociation> weakAssociations;

    @Override
    public TaskExecutor createExecutor() {
        PMCollectionTaskExecutor.refreshTask(this);
        PMCollectionTaskExecutor executor = new PMCollectionTaskExecutor(this);
        executor.setResultsPeriod(Integer.getInteger("com.bwanms.pmcollection.processresults", 900000));
        executor.setBaseTimeStrategy(BaseTimeStrategyFactory.createBaseTimeStrategy());
        return executor.init();
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(table=@Table(name="BwPMCollectionTask_WAssoc"))
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PerformanceCollectionEntity> getEntities() {
        if (null == this.entities) {
            this.entities = new Vector<PerformanceCollectionEntity>();
        }
        return this.entities;
    }

    public void setEntities(List<PerformanceCollectionEntity> entities) {
        this.entities = entities;
    }

    public void setCollectionEntityList(List<Serializable> collEntities, PerformanceCollectionTaskHandler taskHandler) {
        HashMap<Long, PerformanceCollectionEntity> pmEntityMap = new HashMap<Long, PerformanceCollectionEntity>();
        for (PerformanceCollectionEntity pmEntity : this.getEntities()) {
            if (null == pmEntity.getEntity()) continue;
            pmEntityMap.put(pmEntity.getEntityId(), pmEntity);
        }
        this.entities.clear();
        for (Serializable me : collEntities) {
            PerformanceCollectionEntity pmEntity = (PerformanceCollectionEntity)pmEntityMap.get(((Identifiable)((Object)me)).getId());
            if (null != pmEntity) {
                this.entities.add(pmEntity);
                continue;
            }
            pmEntity = taskHandler.createCollectionEntity(me);
            pmEntity.setCollected(false);
            this.entities.add(pmEntity);
        }
    }

    public void initEntities() {
        for (PerformanceCollectionEntity pmEntity : this.getEntities()) {
            pmEntity.initEntity();
        }
    }

    public String[] getCounters() {
        return this.counters;
    }

    public void setCounters(String[] counters) {
        this.counters = counters;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String type) {
        this.entityType = type;
    }

    public int getCountersCategory() {
        return this.countersCategory;
    }

    public void setCountersCategory(int category) {
        this.countersCategory = category;
    }

    public int getStorage() {
        return this.storage;
    }

    public void setStorage(int storage) {
        this.storage = storage;
    }

    public boolean isAutoExport() {
        return this.autoExport;
    }

    public void setAutoExport(boolean autoExport) {
        this.autoExport = autoExport;
    }

    @Transient
    public String getExportFolder() {
        return SystemPropertyUtil.getString("com.bwanms.pmcollection.exportFolder", DEFAULT_EXPORT_FOLDER);
    }

    @OneToMany
    @JoinColumn(name="task_id")
    private List<ManagedTaskWeakAssociation> getWeakAssociations() {
        return this.weakAssociations;
    }

    private void setWeakAssociations(List<ManagedTaskWeakAssociation> weakAssociations) {
        this.weakAssociations = weakAssociations;
    }
}

