/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.task;

import com.bwanms.backend.task.AuditLogDAPTaskExecutor;
import com.bwanms.backend.task.EventHistoryDAPTaskExecutor;
import com.bwanms.model.AuditLogEntry;
import com.bwanms.model.SystemTask;
import com.bwanms.model.Task;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.fault.HistoricalEvent;
import com.bwanms.model.task.Destination;
import com.bwanms.util.EntityUtil;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;

@Entity
@javax.persistence.Table(name="BwDBAgingTask")
public class DatabaseAgingGenericTask
extends Task
implements SystemTask {
    private static final long serialVersionUID = -2596837846096309312L;
    private long period;
    private Destination destination;
    protected Table targetTable;
    protected long threshold;
    protected String secondaryStorage;

    public TaskExecutor createExecutor() {
        if (Table.EventHistory.equals((Object)this.targetTable)) {
            return new EventHistoryDAPTaskExecutor(this);
        }
        if (Table.AuditLog.equals((Object)this.targetTable)) {
            return new AuditLogDAPTaskExecutor(this);
        }
        return null;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    @Column(unique=true)
    public Table getTargetTable() {
        return this.targetTable;
    }

    public String getSecondaryStorage() {
        return this.secondaryStorage;
    }

    public void setSecondaryStorage(String secondaryStorage) {
        this.secondaryStorage = secondaryStorage;
    }

    public void setTargetTable(Table table) {
        this.targetTable = table;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Table {
        EventHistory(HistoricalEvent.class){

            public String toString() {
                return "Event History";
            }
        }
        ,
        AuditLog(AuditLogEntry.class){

            public String toString() {
                return "Audit Log";
            }
        };

        private String tableName;

        private Table(Class<? extends Serializable> clazz) {
            this.tableName = EntityUtil.getTableName(clazz);
        }

        public String tableName() {
            return this.tableName;
        }
    }
}

