/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.license;

import com.bwanms.model.license.LFNodeLockIP;
import com.bwanms.model.license.LFNodeLockMAC;
import com.bwanms.model.license.LicenseFeature;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwLicenseFeatureNodeLock")
public class LicenseFeatureNodeLock
extends LicenseFeature {
    private List<LFNodeLockIP> ipAddresses;
    private List<LFNodeLockMAC> macAddresses;
    private static final int WINDOWS = 0;
    private static final int SOLARIS = 1;

    @Transient
    public List<String> getMacAddressList() {
        ArrayList<String> ret = new ArrayList<String>();
        for (LFNodeLockMAC mac : this.getMacAddresses()) {
            ret.add(mac.getMacAddress());
        }
        return ret;
    }

    @Transient
    public List<String> getIpAddressList() {
        ArrayList<String> ret = new ArrayList<String>();
        for (LFNodeLockIP ip : this.getIpAddresses()) {
            ret.add(ip.getIpAddress());
        }
        return ret;
    }

    public void addIpAddress(String ipAddress) {
        LFNodeLockIP ip = new LFNodeLockIP(ipAddress);
        ip.setFeature(this);
        this.getIpAddresses().add(ip);
    }

    public void addMacAddress(String macAddress) {
        LFNodeLockMAC mac = new LFNodeLockMAC(macAddress);
        mac.setFeature(this);
        this.getMacAddresses().add(mac);
    }

    @Override
    public int checkSumCode() {
        StringBuffer checkSum = new StringBuffer(this.getCheckSumPrefix());
        List<String> ips = this.getIpAddressList();
        Collections.sort(ips);
        for (String ip : ips) {
            checkSum.append(ip);
        }
        List<String> macs = this.getMacAddressList();
        Collections.sort(macs);
        for (String mac : macs) {
            checkSum.append(mac);
        }
        return checkSum.toString().hashCode();
    }

    public boolean checkNode() throws IOException {
        List<String> macs = this.getMacAddressList();
        macs.retainAll(LicenseFeatureNodeLock.getSystemMacAddresses());
        List<String> ips = this.getIpAddressList();
        ips.retainAll(LicenseFeatureNodeLock.getSystemIpAddresses());
        return !macs.isEmpty() && !ips.isEmpty();
    }

    protected static List<String> getSystemIpAddresses() throws IOException {
        ArrayList<String> ips = new ArrayList<String>();
        Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
        while (ifs.hasMoreElements()) {
            NetworkInterface intf = ifs.nextElement();
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                ips.add(addresses.nextElement().getHostAddress());
            }
        }
        return ips;
    }

    protected static List<String> getSystemMacAddresses() throws IOException {
        Process ipcProc = null;
        int os = LicenseFeatureNodeLock.getSystem();
        switch (os) {
            case 0: {
                ipcProc = Runtime.getRuntime().exec("ipconfig.exe /all");
                break;
            }
            case 1: {
                ipcProc = Runtime.getRuntime().exec("/usr/sbin/ifconfig -a");
            }
        }
        InputStream cmdOutput = ipcProc.getInputStream();
        DataInputStream din = new DataInputStream(cmdOutput);
        StringBuffer buff = new StringBuffer();
        String line = null;
        while ((line = din.readLine()) != null) {
            buff.append("\n");
            buff.append(line);
        }
        String output = buff.toString();
        Pattern macPattern = null;
        Matcher macMatcher = null;
        switch (os) {
            case 0: {
                macPattern = Pattern.compile(".{2}?\\-.{2}?\\-.{2}?\\-.{2}?\\-.{2}?\\-.{2}?");
                break;
            }
            case 1: {
                macPattern = Pattern.compile(".{1,2}?\\:.{1,2}?\\:.{1,2}?\\:.{1,2}?\\:.{1,2}?\\:.{1,2}?");
            }
        }
        macMatcher = macPattern.matcher(output);
        ArrayList<String> macs = new ArrayList<String>();
        while (macMatcher.find()) {
            switch (os) {
                case 0: {
                    macs.add(macMatcher.group().toUpperCase());
                    break;
                }
                case 1: {
                    String[] macParts = macMatcher.group().split("\\:");
                    StringBuffer macBuff = new StringBuffer();
                    for (int i = 0; i < macParts.length; ++i) {
                        if (macParts[i].length() < 2) {
                            macBuff.append('0');
                        }
                        macBuff.append(macParts[i]);
                        macBuff.append("-");
                    }
                    macBuff.setLength(macBuff.length() - 1);
                    macs.add(macBuff.toString().toUpperCase());
                }
            }
        }
        return macs;
    }

    private static int getSystem() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") != -1) {
            return 0;
        }
        if (osName.indexOf("sunos") != -1) {
            return 1;
        }
        throw new RuntimeException("Unknown operating system");
    }

    @OneToMany(mappedBy="feature", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<LFNodeLockIP> getIpAddresses() {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<LFNodeLockIP>();
        }
        return this.ipAddresses;
    }

    private void setIpAddresses(List<LFNodeLockIP> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    @OneToMany(mappedBy="feature", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<LFNodeLockMAC> getMacAddresses() {
        if (this.macAddresses == null) {
            this.macAddresses = new ArrayList<LFNodeLockMAC>();
        }
        return this.macAddresses;
    }

    private void setMacAddresses(List<LFNodeLockMAC> macAddresses) {
        this.macAddresses = macAddresses;
    }
}

