/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.license;

import com.bwanms.domain.logic.AuditLogHelper;
import com.bwanms.model.Identifiable;
import com.bwanms.model.license.Licensable;
import com.bwanms.model.license.LicenseFeature;
import com.bwanms.model.license.LicenseFeatureNodeLock;
import com.bwanms.model.license.LicenseFeatureTimed;
import com.bwanms.model.license.LicenseFeatureUsable;
import com.bwanms.model.license.LicenseFile;
import com.bwanms.persistence.Datastore;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BwLicense")
public class License
implements Serializable,
Identifiable {
    private static final Logger log = Logger.getLogger(License.class);
    public static final long TRIAL_CUSTOMER = 0L;
    private long id;
    private long licenseId;
    private String customerName;
    private List<LicenseFeature> licenseFeatures;
    private LicenseFile licenseFile;
    private int checkSum;
    private long installDate = System.currentTimeMillis();
    private int state = 0;
    private boolean active;
    private boolean additive = false;

    @Override
    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(long licenseId) {
        this.licenseId = licenseId;
    }

    public long getInstallDate() {
        return this.installDate;
    }

    private void setInstallDate(long installDate) {
        this.installDate = installDate;
    }

    private int getCheckSum() {
        return this.checkSum;
    }

    private void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    @OneToMany(mappedBy="license", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    public List<LicenseFeature> getLicenseFeatures() {
        if (this.licenseFeatures == null) {
            this.licenseFeatures = new ArrayList<LicenseFeature>();
        }
        return this.licenseFeatures;
    }

    public void setLicenseFeatures(List<LicenseFeature> licenseFeatures) {
        this.licenseFeatures = licenseFeatures;
    }

    @Transient
    public Map<String, LicenseFeature> getLicenseFeaturesMap() {
        HashMap<String, LicenseFeature> ret = new HashMap<String, LicenseFeature>();
        for (LicenseFeature feature : this.getLicenseFeatures()) {
            ret.put(feature.getName(), feature);
        }
        return ret;
    }

    public void addLicenseFeature(LicenseFeature feature) {
        feature.setLicense(this);
        this.getLicenseFeatures().add(feature);
    }

    public boolean compareLicenseBytes(byte[] candidate) {
        byte[] licenseBytes = this.getLicenseFile().getLicenseBytes();
        if (candidate.length != licenseBytes.length) {
            return false;
        }
        for (int i = 0; i < licenseBytes.length; ++i) {
            if (candidate[i] == licenseBytes[i]) continue;
            return false;
        }
        return true;
    }

    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    public LicenseFile getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(LicenseFile licenseFile) {
        this.licenseFile = licenseFile;
    }

    public void setLicenseBytes(byte[] licenseBytes) {
        LicenseFile file = new LicenseFile();
        file.setLicenseBytes(licenseBytes);
        this.setLicenseFile(file);
    }

    public void computeCheckSum() {
        this.setCheckSum(this.computeCheckSumInternal());
    }

    private int computeCheckSumInternal() {
        int cSum = ("" + this.licenseId + this.customerName + this.installDate).hashCode();
        ArrayList<LicenseFeature> sortedFeatures = new ArrayList<LicenseFeature>();
        sortedFeatures.addAll(this.licenseFeatures);
        Collections.sort(sortedFeatures, new Comparator<LicenseFeature>(){

            @Override
            public int compare(LicenseFeature o1, LicenseFeature o2) {
                long o2id;
                long o1id = o1.getId();
                if (o1id < (o2id = o2.getId())) {
                    return -1;
                }
                if (o1id > o2id) {
                    return 1;
                }
                return 0;
            }
        });
        for (LicenseFeature feature : sortedFeatures) {
            cSum = 31 * cSum + feature.checkSumCode();
        }
        return cSum;
    }

    @Transient
    public boolean isValid() {
        return this.state == 0;
    }

    @Transient
    public boolean isSuspended() {
        return this.state == 2;
    }

    public int getState() {
        return this.state;
    }

    private void setState(int state) {
        this.state = state;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean aditive) {
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void checkLicense() {
        this.checkLicenseValidity();
        this.checkExpiration();
        this.checkNodeLock();
    }

    private void checkLicenseValidity() {
        if (this.state == 1) {
            return;
        }
        if (this.getCheckSum() != this.computeCheckSumInternal()) {
            this.invalidateLicense();
        }
    }

    private void checkExpiration() {
        if (this.state == 1) {
            return;
        }
        for (LicenseFeature feature : this.getLicenseFeatures()) {
            if (!(feature instanceof LicenseFeatureTimed) || !((LicenseFeatureTimed)feature).hasExpired()) continue;
            AuditLogHelper.addAuditLogEntryInCurrentSession("SYSTEM", "LicenseExpired", "License", this.getCustomerName(), "License");
            this.invalidateLicense();
            break;
        }
    }

    private void checkNodeLock() {
        if (this.state == 1) {
            return;
        }
        for (LicenseFeature feature : this.getLicenseFeatures()) {
            if (!(feature instanceof LicenseFeatureNodeLock)) continue;
            try {
                if (!((LicenseFeatureNodeLock)feature).checkNode()) {
                    this.suspendLicense();
                } else if (this.isSuspended()) {
                    this.unsuspendLicense();
                }
                return;
            }
            catch (IOException e) {
                log.debug((Object)"", (Throwable)e);
                this.suspendLicense();
                return;
            }
        }
    }

    public void markDeleted() {
        this.deleteUsage();
        this.state = 3;
        this.computeCheckSum();
    }

    private void invalidateLicense() {
        this.deleteUsage();
        this.state = 1;
        this.computeCheckSum();
    }

    private void suspendLicense() {
        this.deleteUsage();
        this.state = 2;
        this.computeCheckSum();
    }

    private void unsuspendLicense() {
        if (this.state != 2) {
            throw new RuntimeException("Invalid license state");
        }
        this.state = 0;
        this.computeCheckSum();
    }

    private void deleteUsage() {
        for (LicenseFeature feature : this.getLicenseFeatures()) {
            if (!(feature instanceof LicenseFeatureUsable)) continue;
            Query query = Datastore.session().createQuery(" update " + Licensable.class.getName() + " set licenseID = " + Licensable.UNLICENSED + " " + " where licenseID = :licenseID ").setLong("licenseID", this.getId());
            query.executeUpdate();
            ((LicenseFeatureUsable)feature).setUsageCount(0);
        }
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
}

