/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.file;

import com.bwanms.model.entity.DefaultAssembly;
import com.bwanms.model.file.AbstractFile;
import com.bwanms.model.file.FileData;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class FileUtil {
    private FileUtil() {
    }

    public static AbstractFile refreshFile(AbstractFile file) throws ServiceException {
        DefaultAssembly assembly = (DefaultAssembly)ServiceRegistry.getEntityManagerService().get(file.getClass(), file.getId(), "Export");
        return (AbstractFile)assembly.getEntity();
    }

    public static byte[] getFileBytes(AbstractFile file) throws ServiceException {
        return FileUtil.getFileBytes(file, false);
    }

    public static byte[] getFileBytes(AbstractFile file, boolean compressed) throws ServiceException {
        FileData fileData;
        if (file == null) {
            throw new IllegalArgumentException("Null file object or null file id");
        }
        DefaultAssembly assembly = (DefaultAssembly)ServiceRegistry.getEntityManagerService().get(file.getClass(), file.getId(), "Export");
        AbstractFile abstractFile = (AbstractFile)assembly.getEntity();
        FileData fileData2 = fileData = abstractFile != null ? abstractFile.getFileData() : null;
        if (compressed) {
            return fileData.getBytes();
        }
        if (fileData != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(fileData.getBytes());
                ZipInputStream zipIn = new ZipInputStream(in);
                zipIn.getNextEntry();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtil.copyStream(zipIn, out);
                out.close();
                zipIn.closeEntry();
                zipIn.close();
                in.close();
                return out.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void setFileBytes(AbstractFile file, byte[] inBytes) {
        if (file == null || file.getId() > 0L) {
            throw new IllegalArgumentException("Null file object or not null file id");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zipOut = new ZipOutputStream(out);
            zipOut.putNextEntry(new ZipEntry("report"));
            ByteArrayInputStream in = new ByteArrayInputStream(inBytes);
            IOUtil.copyStream(in, zipOut);
            zipOut.closeEntry();
            zipOut.close();
            out.close();
            in.close();
            FileData fileData = file.getFileData();
            if (null == fileData) {
                fileData = new FileData();
            }
            fileData.setType((byte)1);
            fileData.setCompressed(true);
            fileData.setBytes(out.toByteArray());
            file.setFileData(fileData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] compressBytes(byte[] inBytes, String fileName) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(out);
        zipOut.putNextEntry(new ZipEntry(fileName));
        zipOut.write(inBytes);
        zipOut.closeEntry();
        zipOut.close();
        out.close();
        return out.toByteArray();
    }

    public static String escapeForFilesystem(String fileName) {
        return fileName.replaceAll("[<>:*|^/\\?\\\\\\\"]", "_");
    }
}

