/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.file;

import com.bwanms.model.Identifiable;
import com.bwanms.model.file.FileData;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="BwAbstractFile")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class AbstractFile
implements Serializable,
Identifiable {
    private long id;
    private long timestamp;
    private FileData fileData;
    private String fileName;
    private String fileCategory;
    private String description;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="fileData_id")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public FileData getFileData() {
        return this.fileData;
    }

    public void setFileData(FileData fileData) {
        this.fileData = fileData;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getFileCategory() {
        return this.fileCategory;
    }

    public void setFileCategory(String fileCategory) {
        this.fileCategory = fileCategory;
    }

    @Transient
    public Date getDate() {
        return new Date(this.getTimestamp());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

