/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.fault.nbi;

import com.bwanms.model.Identifiable;
import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEquipment;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEventCategory;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEventType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterEvtOID;
import com.bwanms.model.fault.nbi.NbiPolicyFilterLocation;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOAlias;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOInst;
import com.bwanms.model.fault.nbi.NbiPolicyFilterMOType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterNEType;
import com.bwanms.model.fault.nbi.NbiPolicyFilterSeverity;
import com.bwanms.model.fault.nbi.NbiPolicyTimeDays;
import com.bwanms.validation.WeakLength;
import com.bwanms.validation.WeakNotNull;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true)
@Table(name="BwNbiPolicy")
public class NbiPolicy
implements Serializable,
Identifiable {
    public static final String TABLE_NAME = "BwNbiPolicy";
    public static final String PROP_NBI = "nbi";
    private long id;
    private Nbi nbi;
    private String name;
    private String description;
    private byte enabled;
    private NbiPolicyFilter policyFilter = new NbiPolicyFilter();
    private NbiPolicyTime policyTime = new NbiPolicyTime();

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    public Nbi getNbi() {
        return this.nbi;
    }

    public void setNbi(Nbi nbi) {
        this.nbi = nbi;
    }

    @WeakNotNull
    @WeakLength(min=1, max=32)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @WeakLength(min=0, max=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public byte getEnabled() {
        return this.enabled;
    }

    public void setEnabled(byte enabled) {
        this.enabled = enabled;
    }

    @Embedded
    public NbiPolicyFilter getPolicyFilter() {
        return this.policyFilter;
    }

    public void setPolicyFilter(NbiPolicyFilter filter) {
        this.policyFilter = filter;
    }

    @Embedded
    public NbiPolicyTime getPolicyTime() {
        return this.policyTime;
    }

    public void setPolicyTime(NbiPolicyTime policyTime) {
        this.policyTime = policyTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Embeddable
    @Entity
    public static class NbiPolicyTime
    implements Serializable {
        private Set<NbiPolicyTimeDays> days = new HashSet<NbiPolicyTimeDays>();
        private long startTime;
        private long endTime;

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyTimeDays> getDays() {
            return this.days;
        }

        public void setDays(Set<NbiPolicyTimeDays> days) {
            this.days = days;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Embeddable
    @Entity
    public static class NbiPolicyFilter
    implements Serializable {
        private Set<NbiPolicyFilterNEType> neTypes = new LinkedHashSet<NbiPolicyFilterNEType>();
        private Set<NbiPolicyFilterSeverity> severities = new LinkedHashSet<NbiPolicyFilterSeverity>();
        private Set<NbiPolicyFilterLocation> locations = new LinkedHashSet<NbiPolicyFilterLocation>();
        private Set<NbiPolicyFilterEquipment> equipments = new LinkedHashSet<NbiPolicyFilterEquipment>();
        private Set<NbiPolicyFilterEvtOID> eventOIDs = new LinkedHashSet<NbiPolicyFilterEvtOID>();
        private Set<NbiPolicyFilterMOType> moTypes = new LinkedHashSet<NbiPolicyFilterMOType>();
        private Set<NbiPolicyFilterEventCategory> eventCategories = new LinkedHashSet<NbiPolicyFilterEventCategory>();
        private Set<NbiPolicyFilterEventType> eventTypes = new LinkedHashSet<NbiPolicyFilterEventType>();
        private Set<NbiPolicyFilterMOInst> moInstances = new LinkedHashSet<NbiPolicyFilterMOInst>();
        private Set<NbiPolicyFilterMOAlias> moAliases = new LinkedHashSet<NbiPolicyFilterMOAlias>();
        private String userClassifier;

        public String getUserClassifier() {
            return this.userClassifier;
        }

        public void setUserClassifier(String userClassifier) {
            this.userClassifier = userClassifier;
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterLocation> getLocations() {
            return this.locations;
        }

        public void setLocations(Set<NbiPolicyFilterLocation> locations) {
            this.locations = locations;
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterNEType> getNeTypes() {
            return this.neTypes;
        }

        public void removeNETypes() {
            this.neTypes.clear();
        }

        public void removeNETypes(NbiPolicyFilterNEType neType) {
            this.neTypes.remove(neType);
        }

        public void setNeTypes(Set<NbiPolicyFilterNEType> neTypes) {
            this.neTypes = neTypes;
        }

        public void addNETypes(NbiPolicyFilterNEType neType) {
            this.neTypes.add(neType);
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterSeverity> getSeverities() {
            return this.severities;
        }

        public void setSeverities(Set<NbiPolicyFilterSeverity> severities) {
            this.severities = severities;
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterEquipment> getEquipments() {
            return this.equipments;
        }

        public void setEquipments(Set<NbiPolicyFilterEquipment> equipments) {
            this.equipments = equipments;
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterEvtOID> getEventOIDs() {
            return this.eventOIDs;
        }

        public void removeEventOIDs() {
            this.eventOIDs.clear();
        }

        public void removeEventOID(NbiPolicyFilterEvtOID eventOID) {
            this.eventOIDs.remove(eventOID);
        }

        public void setEventOIDs(Set<NbiPolicyFilterEvtOID> eventOIDs) {
            this.eventOIDs = eventOIDs;
        }

        public void addEventOID(NbiPolicyFilterEvtOID eventOID) {
            this.eventOIDs.add(eventOID);
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterMOType> getMoTypes() {
            return this.moTypes;
        }

        public void removeMoTypes() {
            this.moTypes.clear();
        }

        public void removeMoType(NbiPolicyFilterMOType moType) {
            this.moTypes.remove(moType);
        }

        public void setMoTypes(Set<NbiPolicyFilterMOType> moTypes) {
            this.moTypes = moTypes;
        }

        public void addMoType(NbiPolicyFilterMOType moType) {
            this.moTypes.add(moType);
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterEventCategory> getEventCategories() {
            return this.eventCategories;
        }

        public void removeEventCategories() {
            this.eventCategories.clear();
        }

        public void removeEventCategories(NbiPolicyFilterEventCategory eventCategory) {
            this.eventCategories.remove(eventCategory);
        }

        public void setEventCategories(Set<NbiPolicyFilterEventCategory> eventCategories) {
            this.eventCategories = eventCategories;
        }

        public void addEventCategories(NbiPolicyFilterEventCategory eventCategory) {
            this.eventCategories.add(eventCategory);
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterEventType> getEventTypes() {
            return this.eventTypes;
        }

        public void removeEventTypes() {
            this.eventTypes.clear();
        }

        public void removeEventTypes(NbiPolicyFilterEventType eventType) {
            this.eventTypes.remove(eventType);
        }

        public void setEventTypes(Set<NbiPolicyFilterEventType> eventTypes) {
            this.eventTypes = eventTypes;
        }

        public void addEventTypes(NbiPolicyFilterEventType eventType) {
            this.eventTypes.add(eventType);
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterMOInst> getMoInstances() {
            return this.moInstances;
        }

        public void removeMoInstances() {
            this.moInstances.clear();
        }

        public void removeMoInstances(NbiPolicyFilterMOInst moInstance) {
            this.moInstances.remove(moInstance);
        }

        public void setMoInstances(Set<NbiPolicyFilterMOInst> moInstances) {
            this.moInstances = moInstances;
        }

        public void addMoInstances(NbiPolicyFilterMOInst moInstance) {
            this.moInstances.add(moInstance);
        }

        @OneToMany(mappedBy="nbiPolicy", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
        @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
        public Set<NbiPolicyFilterMOAlias> getMoAliases() {
            return this.moAliases;
        }

        public void removeMoAliases() {
            this.moAliases.clear();
        }

        public void removeMoAliases(NbiPolicyFilterMOAlias moAlias) {
            this.moAliases.remove(moAlias);
        }

        public void setMoAliases(Set<NbiPolicyFilterMOAlias> moAliases) {
            this.moAliases = moAliases;
        }

        public void addMoAliases(NbiPolicyFilterMOAlias moAlias) {
            this.moAliases.add(moAlias);
        }
    }
}

