/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.fault.nbi;

import com.bwanms.model.Identifiable;
import com.bwanms.model.fault.nbi.NbiPolicy;
import com.bwanms.model.fault.nbi.NbiProtocolParams;
import com.bwanms.model.fault.nbi.NbiSNMPParams;
import com.bwanms.validation.IPv4Address;
import com.bwanms.validation.WeakLength;
import com.bwanms.validation.WeakNotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true)
@Table(name="BwNbi")
public class Nbi
implements Serializable,
Identifiable {
    public static final String TABLE_NAME = "BwNbi";
    private long id;
    private String name;
    private String description;
    private byte enabled;
    private String ipAddress;
    private String user;
    private String password;
    private NbiProtocolParams protocolParams = new NbiSNMPParams();
    private List<NbiPolicy> policies = new ArrayList<NbiPolicy>();

    @Override
    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @WeakNotNull
    @WeakLength(min=1, max=32)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @WeakLength(min=0, max=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public byte getEnabled() {
        return this.enabled;
    }

    public void setEnabled(byte enabled) {
        this.enabled = enabled;
    }

    @IPv4Address
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public NbiProtocolParams getProtocolParams() {
        return this.protocolParams;
    }

    public void setProtocolParams(NbiProtocolParams protocolParams) {
        this.protocolParams = protocolParams;
    }

    @OneToMany(mappedBy="nbi", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<NbiPolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<NbiPolicy> policies) {
        this.policies = policies;
    }

    @Transient
    public List<NbiPolicy> visitPolicies() {
        this.policies.size();
        return this.policies;
    }

    @Column(name="UserPassword")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name="UserName")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void removePolicy(NbiPolicy policy) {
        this.getPolicies().remove(policy);
    }
}

