/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.fault.constants;

import com.bwanms.model.fault.constants.EventFilterConstantsProvider;
import com.bwanms.model.fault.constants.MOType;
import com.bwanms.model.fault.constants.NEType;
import com.bwanms.model.fault.constants.NMSTrap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMSEvtFilterConstantsProvider
implements EventFilterConstantsProvider {
    private static NMSTrap[] BS_TRAPS = new NMSTrap[]{NMSTrap.nmsManagedEntityCreated, NMSTrap.nmsManagedEntityRemoved, NMSTrap.nmsEquipmentUnreachable, NMSTrap.nmsEquipmentUp, NMSTrap.nmsEquipmentDown, NMSTrap.nmsEquipmentResetDetected};
    private static NMSTrap[] SU_TRAPS = new NMSTrap[]{NMSTrap.nmsManagedEntityCreated, NMSTrap.nmsManagedEntityRemoved, NMSTrap.nmsEquipmentUnreachable, NMSTrap.nmsEquipmentUp, NMSTrap.nmsEquipmentDown};
    private static NMSTrap[] TASK_TRAPS = new NMSTrap[]{NMSTrap.nmsDatabaseAgingReport};

    @Override
    public boolean accept(Enum<?> arg) {
        if (arg == null) {
            return false;
        }
        Class<?> clazz = arg.getClass();
        return NEType.class.isAssignableFrom(clazz) || MOType.class.isAssignableFrom(clazz) || NMSTrap.class.isAssignableFrom(clazz);
    }

    @Override
    public Enum<?>[] getNETypes() {
        return new NEType[]{NEType.NMS};
    }

    @Override
    public Enum<?>[] getMOTypes() {
        return MOType.values();
    }

    @Override
    public Enum<?>[] getTrapTypes() {
        return NMSTrap.values();
    }

    @Override
    public Enum<?>[] getMOTypes(Enum<?> neType) {
        if (neType == null || !NEType.class.isAssignableFrom(neType.getClass())) {
            throw new IllegalArgumentException("NE Type not accepted or null");
        }
        return new MOType[]{MOType.BS, MOType.CPE, MOType.TASK};
    }

    @Override
    public Enum<?>[] getTrapTypes(Enum<?> moType) {
        if (moType == null || !MOType.class.isAssignableFrom(moType.getClass())) {
            throw new IllegalArgumentException("MO Type not accepted or null");
        }
        if (MOType.BS.equals(moType)) {
            return BS_TRAPS;
        }
        if (MOType.CPE.equals(moType)) {
            return SU_TRAPS;
        }
        if (MOType.TASK.equals(moType)) {
            return TASK_TRAPS;
        }
        return NMSTrap.values();
    }

    @Override
    public Enum<?> findMOType(int value) {
        for (MOType moType : MOType.values()) {
            if (moType.value() != value) continue;
            return moType;
        }
        return null;
    }

    @Override
    public Enum<?> findNEType(int value) {
        for (NEType neType : NEType.values()) {
            if (neType.value() != value) continue;
            return neType;
        }
        return null;
    }

    @Override
    public Enum<?> findTrapType(String oid) {
        for (NMSTrap trapType : NMSTrap.values()) {
            if (!trapType.oid().equals(oid)) continue;
            return trapType;
        }
        return null;
    }
}

