/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.fault.constants;

import com.bwanms.model.fault.constants.EventCategory;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EventType {
    other(1),
    communicationsAlarm(2),
    qualityOfServiceAlarm(3),
    processingErrorAlarm(4),
    equipmentAlarm(5),
    environmentalAlarm(6),
    integrityViolation(7),
    operationalViolation(8),
    physicalViolation(9),
    securityServiceOrMechanismViolation(10),
    timeDomainViolation(11),
    stateOrStatusChange(21),
    configChange(31),
    entityAdded(32),
    entityChanged(33),
    entityRemoved(34),
    systemEvent(41),
    unexpectedValue(Integer.MAX_VALUE);

    private int value;
    private static final Map<EventCategory, EventType[]> typesMap;

    public static EventType fromValue(int value) {
        for (EventType constant : EventType.values()) {
            if (constant.value() != value) continue;
            return constant;
        }
        EventType.unexpectedValue.value = value;
        return unexpectedValue;
    }

    private EventType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public String toString() {
        if (this.value == EventType.unexpectedValue.value) {
            return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name() + "(" + this.value() + ")";
    }

    public static EventType[] valuesByCategory(EventCategory category) {
        return typesMap.get((Object)category);
    }

    static {
        typesMap = new HashMap<EventCategory, EventType[]>();
        typesMap.put(EventCategory.Alarm, new EventType[]{other, communicationsAlarm, qualityOfServiceAlarm, processingErrorAlarm, equipmentAlarm, environmentalAlarm, integrityViolation, operationalViolation, physicalViolation, securityServiceOrMechanismViolation, timeDomainViolation});
        typesMap.put(EventCategory.StateChange, new EventType[]{stateOrStatusChange});
        typesMap.put(EventCategory.SysEvent, new EventType[]{systemEvent});
        typesMap.put(EventCategory.ConfigChange, new EventType[]{configChange, entityAdded, entityChanged, entityRemoved});
    }
}

