/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.fault;

import com.bwanms.model.Identifiable;
import com.bwanms.model.fault.EventTemplateBehavior;
import com.bwanms.model.fault.EventTemplateFilter;
import com.bwanms.validation.WeakLength;
import com.bwanms.validation.WeakNotNull;
import com.bwanms.validation.WeakRange;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true)
@Table(name="BwEventTemplate")
@NamedQueries(value={@NamedQuery(name="matchEvents", queryString="SELECT et  FROM EventTemplate AS et  JOIN et.filter AS etf  LEFT JOIN etf.severities AS sev  LEFT JOIN etf.eventCategories AS ec  LEFT JOIN etf.eventTypes AS evt  LEFT JOIN etf.neTypes AS net  LEFT JOIN etf.moTypes AS mot  LEFT JOIN etf.eventOIDs AS oid  LEFT JOIN etf.locations AS loc  LEFT JOIN etf.networkElements AS ne  LEFT JOIN etf.moInstances AS moi  LEFT JOIN etf.moAliases AS moa  WHERE  (ec.eventCategory IS NULL OR ec.eventCategory = :eventCategory) AND (evt.eventType IS NULL OR evt.eventType = :eventType) AND (net.neType IS NULL OR net.neType = :networkElementType) AND (moi.moInst IS NULL OR moi.moInst = :moInstance)  AND (moa.moAlias IS NULL OR moa.moAlias = :moAlias)  AND (sev.severity IS NULL OR sev.severity = :severity)  AND (mot.moType IS NULL OR mot.moType = :moType)  AND (oid.eventOID IS NULL OR oid.eventOID = :eventOID)  AND (loc.locationID IS NULL OR loc.locationID = :locationId)  AND (ne.equipmentID IS NULL OR ne.equipmentID = :networkElement)  ORDER BY et.priority ASC")})
public class EventTemplate
implements Serializable,
Identifiable {
    public static final String PROP_FILTER = "filter";
    private long id;
    private String name;
    private String description;
    private Long priority;
    private String owner;
    private long creationDate;
    private EventTemplateFilter filter = new EventTemplateFilter();
    private EventTemplateBehavior behavior = new EventTemplateBehavior();

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @WeakRange(min=1L, max=99999L)
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @WeakNotNull
    @WeakLength(min=1, max=128)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="filterId")
    public EventTemplateFilter getFilter() {
        return this.filter;
    }

    public void setFilter(EventTemplateFilter filter) {
        this.filter = filter;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="behaviorId")
    public EventTemplateBehavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(EventTemplateBehavior behavior) {
        this.behavior = behavior;
    }

    public String toString() {
        return String.format("%s [%s, %s, %d, %s, %d]", this.getClass().getSimpleName(), this.name, this.description, this.priority, this.owner, this.creationDate);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventTemplate other = (EventTemplate)obj;
        return this.id == other.id;
    }
}

