/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.fault;

import com.bwanms.model.Identifiable;
import com.bwanms.model.fault.EvtFilterEquipment;
import com.bwanms.model.fault.EvtFilterEventCategory;
import com.bwanms.model.fault.EvtFilterEventType;
import com.bwanms.model.fault.EvtFilterEvtOID;
import com.bwanms.model.fault.EvtFilterLocation;
import com.bwanms.model.fault.EvtFilterMOAlias;
import com.bwanms.model.fault.EvtFilterMOInst;
import com.bwanms.model.fault.EvtFilterMOType;
import com.bwanms.model.fault.EvtFilterNEType;
import com.bwanms.model.fault.EvtFilterSeverity;
import com.bwanms.validation.WeakLength;
import com.bwanms.validation.WeakNotNull;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true)
@Table(name="BwEventFilter")
public class EventFilter
implements Serializable,
Identifiable {
    public static final String COL_ID = "Id";
    public static final String PROP_MO_TYPES = "moTypes";
    public static final String PROP_NE_NAME = "NEName";
    public static final String PROP_EVENT_CATEGORY = "eventCategory";
    public static final String PROP_EVENT_TYPE = "eventType";
    public static final String PROP_MO_INSTANCE = "moInstance";
    public static final String PROP_LOCATIONS = "locations";
    public static final String PROP_NETWORK_ELEMENTS = "networkElements";
    public static final String PROP_FROM_DATE = "fromDate";
    public static final String PROP_TO_DATE = "toDate";
    private long id;
    private String name;
    private String description;
    private String owner;
    private long creationDate;
    private boolean acknowledged;
    private boolean cleared;
    private String userClassifier;
    private Set<EvtFilterEventCategory> eventCategories = new LinkedHashSet<EvtFilterEventCategory>();
    private Set<EvtFilterEventType> eventTypes = new HashSet<EvtFilterEventType>();
    private Set<EvtFilterNEType> neTypes = new LinkedHashSet<EvtFilterNEType>();
    private Set<EvtFilterSeverity> severities = new HashSet<EvtFilterSeverity>();
    private Set<EvtFilterMOType> moTypes = new LinkedHashSet<EvtFilterMOType>();
    private Set<EvtFilterEvtOID> eventOIDs = new HashSet<EvtFilterEvtOID>();
    private Set<EvtFilterEquipment> equipmentIDs = new HashSet<EvtFilterEquipment>();
    private Set<EvtFilterLocation> locationIDs = new HashSet<EvtFilterLocation>();
    private Set<EvtFilterMOInst> moInstances = new HashSet<EvtFilterMOInst>();
    private Set<EvtFilterMOAlias> moAliases = new HashSet<EvtFilterMOAlias>();

    @Override
    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @WeakNotNull
    @WeakLength(min=1, max=32)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterSeverity> getSeverities() {
        return this.severities;
    }

    public void removeSeverities() {
        this.severities.clear();
    }

    public void removeSeverity(EvtFilterSeverity severity) {
        this.severities.remove(severity);
    }

    public void setSeverities(Set<EvtFilterSeverity> severities) {
        this.severities = severities;
    }

    public void addSeverity(EvtFilterSeverity severity) {
        this.severities.add(severity);
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterMOType> getMoTypes() {
        return this.moTypes;
    }

    public void removeMoTypes() {
        this.moTypes.clear();
    }

    public void removeMoType(EvtFilterMOType moType) {
        this.moTypes.remove(moType);
    }

    public void setMoTypes(Set<EvtFilterMOType> moType) {
        this.moTypes = moType;
    }

    public void addMoType(EvtFilterMOType moType) {
        this.moTypes.add(moType);
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterEvtOID> getEventOIDs() {
        return this.eventOIDs;
    }

    public void removeEventOIDs() {
        this.eventOIDs.clear();
    }

    public void removeEventOID(EvtFilterEvtOID eventOID) {
        this.eventOIDs.remove(eventOID);
    }

    public void setEventOIDs(Set<EvtFilterEvtOID> eventOIDs) {
        this.eventOIDs = eventOIDs;
    }

    public void addEventOID(EvtFilterEvtOID eventOID) {
        this.eventOIDs.add(eventOID);
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterEquipment> getEquipmentIDs() {
        return this.equipmentIDs;
    }

    public void removeEquipmentIDs() {
        this.equipmentIDs.clear();
    }

    public void removeEquipmentIDs(EvtFilterEquipment equipmentIDs) {
        this.equipmentIDs.remove(equipmentIDs);
    }

    public void setEquipmentIDs(Set<EvtFilterEquipment> equipmentIDs) {
        this.equipmentIDs = equipmentIDs;
    }

    public void addEquipmentIDs(EvtFilterEquipment equipmentIDs) {
        this.equipmentIDs.add(equipmentIDs);
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterLocation> getLocationIDs() {
        return this.locationIDs;
    }

    public void removeLocationIDs() {
        this.locationIDs.clear();
    }

    public void removeLocationIDs(EvtFilterLocation locationIDs) {
        this.locationIDs.remove(locationIDs);
    }

    public void setLocationIDs(Set<EvtFilterLocation> locationIDs) {
        this.locationIDs = locationIDs;
    }

    public void addLocationIDs(EvtFilterLocation locationIDs) {
        this.locationIDs.add(locationIDs);
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterNEType> getNeTypes() {
        return this.neTypes;
    }

    public void removeNETypes() {
        this.neTypes.clear();
    }

    public void removeNETypes(EvtFilterNEType neType) {
        this.neTypes.remove(neType);
    }

    public void setNeTypes(Set<EvtFilterNEType> neTypes) {
        this.neTypes = neTypes;
    }

    public void addNETypes(EvtFilterNEType neType) {
        this.neTypes.add(neType);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getUserClassifier() {
        return this.userClassifier;
    }

    public void setUserClassifier(String userClassifier) {
        this.userClassifier = userClassifier;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public void setAcknowledged(boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterEventCategory> getEventCategories() {
        return this.eventCategories;
    }

    public void removeEventCategories() {
        this.eventCategories.clear();
    }

    public void removeEventCategory(EvtFilterEventCategory eventCategory) {
        this.eventCategories.remove(eventCategory);
    }

    public void setEventCategories(Set<EvtFilterEventCategory> eventCategories) {
        this.eventCategories = eventCategories;
    }

    public void addEventCategory(EvtFilterEventCategory eventCategory) {
        this.eventCategories.add(eventCategory);
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterEventType> getEventTypes() {
        return this.eventTypes;
    }

    public void removeEventTypes() {
        this.eventTypes.clear();
    }

    public void removeEventType(EvtFilterEventType eventType) {
        this.eventTypes.remove(eventType);
    }

    public void setEventTypes(Set<EvtFilterEventType> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public void addEventType(EvtFilterEventType eventType) {
        this.eventTypes.add(eventType);
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterMOInst> getMoInstances() {
        return this.moInstances;
    }

    public void removeMoInstances() {
        this.moInstances.clear();
    }

    public void removeMoInstance(EvtFilterMOInst moInstance) {
        this.moInstances.remove(moInstance);
    }

    public void setMoInstances(Set<EvtFilterMOInst> moInstances) {
        this.moInstances = moInstances;
    }

    public void addMoInstance(EvtFilterMOInst moInstance) {
        this.moInstances.add(moInstance);
    }

    @OneToMany(mappedBy="eventFilter", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<EvtFilterMOAlias> getMoAliases() {
        return this.moAliases;
    }

    public void removeMoAliases() {
        this.moAliases.clear();
    }

    public void removeMoAlias(EvtFilterMOAlias moAlias) {
        this.moAliases.remove(moAlias);
    }

    public void setMoAliases(Set<EvtFilterMOAlias> moAliases) {
        this.moAliases = moAliases;
    }

    public void addMoAlias(EvtFilterMOAlias moAlias) {
        this.moAliases.add(moAlias);
    }
}

