/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.fault;

import com.bwanms.gui.Internationalizer;
import com.bwanms.mediation.snmp.SNMPTrapAgentEvent;
import com.bwanms.model.fault.HistoricalEvent;
import com.bwanms.model.fault.HistoricalEventSecondary;
import com.bwanms.model.fault.OperationalEvent;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.util.EntityUtil;
import com.bwanms.util.fault.EventUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.LobType;

public class Event
implements Serializable {
    private long id;
    private long sequenceNumber;
    private long eventTime;
    private long receiveTime;
    private long lastUpdateTime;
    private String locationName;
    private long locationId;
    private String equipmentName;
    private long equipmentId;
    private int equipmentType;
    private String sourceIPAddress;
    private byte protocol;
    private String managedObject;
    private byte moType;
    private String moInstance;
    private String moAlias;
    private String eventOID;
    private byte eventCategory;
    private byte eventType;
    private String eventName;
    private String eventDescription;
    private Serializable eventCause;
    private boolean audible;
    private boolean ackRequired;
    private String userClassifier;
    private byte deleted;
    private byte eventSeverity;
    private byte objectSeverity;
    private int probableCause;
    private String specificProblem;
    private long correlationEventId;
    private String ackedBy;
    private long ackTime;
    private String clearedBy;
    private long clearTime;
    private String eventAdvisor;
    private String proposedRepairAction;
    private String eventNotes;
    private byte administrativeState;
    private byte operationalState;
    private byte usageState;
    private byte alarmStatus;
    private byte proceduralStatus;
    private byte availabilityStatus;
    private byte controlStatus;
    private byte standbyStatus;
    private byte lifecycleStatus;
    private byte unknownStatus;
    private long secondaryId;
    static final String TABLE_NAME = "BwHistoricalEvent";
    static final String COL_ID = "id";
    static final String COL_SEQUENCE_NUMBER = "sequenceNumber";
    static final String COL_EQUIPMENT_ID = "equipmentId";
    static final String COL_EQUIPMENT_NAME = "equipmentName";
    static final String COL_EQUIPMENT_TYPE = "equipmentType";
    static final String COL_SOURCE_IP_ADDRESS = "sourceIpAddress";
    static final String COL_PROTOCOL = "protocol";
    static final String COL_LOCATION_ID = "locationId";
    static final String COL_LOCATION_NAME = "locationName";
    static final String COL_MANAGED_OBJECT = "managedObject";
    static final String COL_MO_TYPE = "moType";
    static final String COL_MO_INSTANCE = "moInstance";
    static final String COL_MO_ALIAS = "moAlias";
    static final String COL_EVENT_OID = "eventOID";
    static final String COL_EVENT_CATEGORY = "eventCategory";
    static final String COL_EVENT_TYPE = "eventType";
    static final String COL_EVENT_NAME = "eventName";
    static final String COL_EVENT_DESCRIPTION = "eventDescription";
    static final String COL_EVENT_SEVERITY = "eventSeverity";
    static final String COL_OBJECT_SEVERITY = "objectSeverity";
    static final String COL_PROBABLE_CAUSE = "probableCause";
    static final String COL_SPECIFIC_PROBLEM = "specificProblem";
    static final String COL_CORRELATION_EVENT_ID = "correlationEventId";
    static final String COL_EVENT_ADVISOR = "eventAdvisor";
    static final String COL_PROPOSED_REPAIR_ACTION = "proposedRepairAction";
    static final String COL_EVENT_NOTES = "eventNotes";
    static final String COL_EVENT_TIME = "eventTime";
    static final String COL_RECEIVE_TIME = "receiveTime";
    static final String COL_LAST_UPDATE_TIME = "lastUpdateTime";
    static final String COL_ACK_TIME = "ackTime";
    static final String COL_ACKED_BY = "ackedBy";
    static final String COL_CLEAR_TIME = "clearTime";
    static final String COL_CLEAR_BY = "clearedBy";
    static final String COL_AUDIBLE = "audible";
    static final String COL_ACK_REQUIRED = "ackRequired";
    static final String COL_USER_CLASSIFIER = "userClassifier";
    static final String COL_DELETED = "deleted";
    static final String COL_ADMIN_STATE = "administrativeState";
    static final String COL_OPER_STATE = "operationalState";
    static final String COL_USAGE_STATE = "usageState";
    static final String COL_ALARM_STATUS = "alarmStatus";
    static final String COL_PROC_STATUS = "proceduralStatus";
    static final String COL_AVAIL_STATUS = "availabilityStatus";
    static final String COL_CONTROL_STATUS = "controlStatus";
    static final String COL_STANDBY_STATUS = "standbyStatus";
    static final String COL_LIFE_STATUS = "lifecycleStatus";
    static final String COL_UNKNOWN_STATUS = "unknownStatus";
    static final String COL_SECONDARY_ID = "secondaryId";
    static final String COL_EVENT_CAUSE = "eventCause";

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public void setReceiveTime(long receiveTime) {
        this.receiveTime = receiveTime;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(long locationId) {
        this.locationId = locationId;
    }

    public String getEquipmentName() {
        return this.equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

    public long getEquipmentId() {
        return this.equipmentId;
    }

    public void setEquipmentId(long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public int getEquipmentType() {
        return this.equipmentType;
    }

    public void setEquipmentType(int equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getManagedObject() {
        return this.managedObject;
    }

    public void setManagedObject(String managedObject) {
        this.managedObject = managedObject;
    }

    public String getSourceIPAddress() {
        return this.sourceIPAddress;
    }

    public void setSourceIPAddress(String sourceIPAddress) {
        this.sourceIPAddress = sourceIPAddress;
    }

    public byte getEventCategory() {
        return this.eventCategory;
    }

    public void setEventCategory(byte eventCategory) {
        this.eventCategory = eventCategory;
    }

    public byte getEventType() {
        return this.eventType;
    }

    public void setEventType(byte eventType) {
        this.eventType = eventType;
    }

    public String getEventDescription() {
        return this.eventDescription;
    }

    public void setEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
    }

    public byte getEventSeverity() {
        return this.eventSeverity;
    }

    public void setEventSeverity(byte eventSeverity) {
        this.eventSeverity = eventSeverity;
    }

    public byte getObjectSeverity() {
        return this.objectSeverity;
    }

    public void setObjectSeverity(byte objectSeverity) {
        this.objectSeverity = objectSeverity;
    }

    public String getAckedBy() {
        return this.ackedBy;
    }

    public void setAckedBy(String ackedBy) {
        this.ackedBy = ackedBy;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(long ackTime) {
        this.ackTime = ackTime;
    }

    public String getClearedBy() {
        return this.clearedBy;
    }

    public void setClearedBy(String clearedBy) {
        this.clearedBy = clearedBy;
    }

    public long getClearTime() {
        return this.clearTime;
    }

    public void setClearTime(long clearTime) {
        this.clearTime = clearTime;
    }

    public boolean isAckRequired() {
        return this.ackRequired;
    }

    public void setAckRequired(boolean ackRequired) {
        this.ackRequired = ackRequired;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getMoInstance() {
        return this.moInstance;
    }

    public void setMoInstance(String instance) {
        this.moInstance = instance;
    }

    public String getMoAlias() {
        return this.moAlias;
    }

    public void setMoAlias(String name) {
        this.moAlias = name;
    }

    public byte getMoType() {
        return this.moType;
    }

    public void setMoType(byte moType) {
        this.moType = moType;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public void setProtocol(byte protocol) {
        this.protocol = protocol;
    }

    public String getEventOID() {
        return this.eventOID;
    }

    public void setEventOID(String OID2) {
        this.eventOID = OID2;
    }

    public String toString() {
        return String.format("Event (category = %s, severity = %s) ", EventCategory.fromValue(this.getEventCategory()).toString(), Severity.fromValue(this.getEventSeverity()).toString());
    }

    public long getCorrelationEventId() {
        return this.correlationEventId;
    }

    public void setCorrelationEventId(long correlationEventId) {
        this.correlationEventId = correlationEventId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public byte getDeleted() {
        return this.deleted;
    }

    public void setDeleted(byte deleted) {
        this.deleted = deleted;
    }

    @Lob(type=LobType.BLOB, fetch=FetchType.LAZY)
    public Serializable getEventCause() {
        return this.eventCause;
    }

    public void setEventCause(Serializable eventCause) {
        if (!(eventCause instanceof SNMPTrapAgentEvent)) {
            throw new IllegalArgumentException("Event cause must be an instance of SNMPTrapAgentEvent or its subclasses");
        }
        this.eventCause = eventCause;
    }

    public int getProbableCause() {
        return this.probableCause;
    }

    public void setProbableCause(int probableCause) {
        this.probableCause = probableCause;
    }

    public String getEventAdvisor() {
        return this.eventAdvisor;
    }

    public void setEventAdvisor(String eventAdvisor) {
        this.eventAdvisor = eventAdvisor;
    }

    public String getEventNotes() {
        return this.eventNotes;
    }

    public void setEventNotes(String eventNotes) {
        this.eventNotes = eventNotes;
    }

    public String getProposedRepairAction() {
        return this.proposedRepairAction;
    }

    public void setProposedRepairAction(String proposedRepairAction) {
        this.proposedRepairAction = proposedRepairAction;
    }

    public byte getAdministrativeState() {
        return this.administrativeState;
    }

    public void setAdministrativeState(byte administrativeState) {
        this.administrativeState = administrativeState;
    }

    public byte getAlarmStatus() {
        return this.alarmStatus;
    }

    public void setAlarmStatus(byte alarmStatus) {
        this.alarmStatus = alarmStatus;
    }

    public byte getAvailabilityStatus() {
        return this.availabilityStatus;
    }

    public void setAvailabilityStatus(byte availabilityStatus) {
        this.availabilityStatus = availabilityStatus;
    }

    public byte getControlStatus() {
        return this.controlStatus;
    }

    public void setControlStatus(byte controlStatus) {
        this.controlStatus = controlStatus;
    }

    public byte getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(byte lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public byte getOperationalState() {
        return this.operationalState;
    }

    public void setOperationalState(byte operationalState) {
        this.operationalState = operationalState;
    }

    public byte getProceduralStatus() {
        return this.proceduralStatus;
    }

    public void setProceduralStatus(byte proceduralStatus) {
        this.proceduralStatus = proceduralStatus;
    }

    public String getSpecificProblem() {
        return this.specificProblem;
    }

    public void setSpecificProblem(String specificProblem) {
        this.specificProblem = specificProblem;
    }

    public byte getStandbyStatus() {
        return this.standbyStatus;
    }

    public void setStandbyStatus(byte standbyStatus) {
        this.standbyStatus = standbyStatus;
    }

    public byte getUnknownStatus() {
        return this.unknownStatus;
    }

    public void setUnknownStatus(byte unknownStatus) {
        this.unknownStatus = unknownStatus;
    }

    public byte getUsageState() {
        return this.usageState;
    }

    public void setUsageState(byte usageState) {
        this.usageState = usageState;
    }

    public String getUserClassifier() {
        return this.userClassifier;
    }

    public void setUserClassifier(String userClassifier) {
        this.userClassifier = userClassifier;
    }

    public boolean isAudible() {
        return this.audible;
    }

    public void setAudible(boolean audible) {
        this.audible = audible;
    }

    public long getSecondaryId() {
        return this.secondaryId;
    }

    public void setSecondaryId(long secondaryId) {
        this.secondaryId = secondaryId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        id("id"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setId(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setBigDecimal(this.getPos(pos), new BigDecimal(event.getId()));
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return String.valueOf(event.getId());
            }
        }
        ,
        sequenceNumber("sequenceNumber"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setSequenceNumber(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getSequenceNumber());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return String.valueOf(event.getSequenceNumber());
            }
        }
        ,
        equipmentId("equipmentId"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEquipmentId(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getEquipmentId());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return String.valueOf(event.getEquipmentId());
            }
        }
        ,
        equipmentName("equipmentName"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEquipmentName(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getEquipmentName());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getEquipmentName();
            }
        }
        ,
        equipmentType("equipmentType"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEquipmentType(rs.getInt(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setInt(this.getPos(pos), event.getEquipmentType());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        sourceIPAddress("sourceIpAddress"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setSourceIPAddress(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getSourceIPAddress());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getSourceIPAddress();
            }
        }
        ,
        protocol("protocol"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setProtocol(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getProtocol());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        locationId("locationId"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setLocationId(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getLocationId());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return String.valueOf(event.getLocationId());
            }
        }
        ,
        locationName("locationName"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setLocationName(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getLocationName());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getLocationName();
            }
        }
        ,
        managedObject("managedObject"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setManagedObject(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getManagedObject());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getManagedObject();
            }
        }
        ,
        moType("moType"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setMoType(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getMoType());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        moInstance("moInstance"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setMoInstance(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getMoInstance());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getMoInstance();
            }
        }
        ,
        moAlias("moAlias"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setMoAlias(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getMoAlias());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getMoAlias();
            }
        }
        ,
        eventOID("eventOID"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEventOID(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getEventOID());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        eventCategory("eventCategory"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEventCategory(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getEventCategory());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return EventUtil.translateEventCategory(event, i18n);
            }
        }
        ,
        eventType("eventType"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEventType(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getEventType());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return EventUtil.translateEventType(event, i18n);
            }
        }
        ,
        eventName("eventName"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEventName(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getEventName());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getEventName();
            }
        }
        ,
        eventDescription("eventDescription"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEventDescription(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getEventDescription());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getEventDescription();
            }
        }
        ,
        eventSeverity("eventSeverity"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEventSeverity(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getEventSeverity());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return EventUtil.translateEventSeverity(event, i18n);
            }
        }
        ,
        objectSeverity("objectSeverity"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setObjectSeverity(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getObjectSeverity());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        probableCause("probableCause"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setProbableCause(rs.getInt(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setInt(this.getPos(pos), event.getProbableCause());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return EventUtil.translateProbableCause(event, i18n);
            }
        }
        ,
        specificProblem("specificProblem"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setSpecificProblem(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getSpecificProblem());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getSpecificProblem();
            }
        }
        ,
        correlationEventId("correlationEventId"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setCorrelationEventId(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getCorrelationEventId());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        eventAdvisor("eventAdvisor"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEventAdvisor(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getEventAdvisor());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getEventAdvisor();
            }
        }
        ,
        proposedRepairAction("proposedRepairAction"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setProposedRepairAction(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getProposedRepairAction());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getProposedRepairAction();
            }
        }
        ,
        eventNotes("eventNotes"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEventNotes(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getEventNotes());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getEventNotes();
            }
        }
        ,
        eventTime("eventTime"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setEventTime(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getEventTime());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return EventUtil.formatTimestamp(event.getEventTime());
            }
        }
        ,
        receiveTime("receiveTime"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setReceiveTime(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getReceiveTime());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return EventUtil.formatTimestamp(event.getReceiveTime());
            }
        }
        ,
        lastUpdateTime("lastUpdateTime"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setLastUpdateTime(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getLastUpdateTime());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return EventUtil.formatTimestamp(event.getLastUpdateTime());
            }
        }
        ,
        ackTime("ackTime"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setAckTime(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getAckTime());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return EventUtil.formatTimestamp(event.getAckTime());
            }
        }
        ,
        ackedBy("ackedBy"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setAckedBy(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getAckedBy());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getAckedBy();
            }
        }
        ,
        clearTime("clearTime"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setClearTime(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getClearTime());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return EventUtil.formatTimestamp(event.getClearTime());
            }
        }
        ,
        clearedBy("clearedBy"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setClearedBy(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getClearedBy());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getClearedBy();
            }
        }
        ,
        audible("audible"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setAudible(rs.getBoolean(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setBoolean(this.getPos(pos), event.isAudible());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        ackRequired("ackRequired"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setAckRequired(rs.getBoolean(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setBoolean(this.getPos(pos), event.isAckRequired());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        userClassifier("userClassifier"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setUserClassifier(rs.getString(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setString(this.getPos(pos), event.getUserClassifier());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return event.getUserClassifier();
            }
        }
        ,
        deleted("deleted"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setDeleted(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getDeleted());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        administrativeState("administrativeState"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setAdministrativeState(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getAdministrativeState());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        operationalState("operationalState"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setOperationalState(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getOperationalState());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        usageState("usageState"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setUsageState(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getUsageState());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        alarmStatus("alarmStatus"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setAlarmStatus(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getAlarmStatus());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        proceduralStatus("proceduralStatus"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setProceduralStatus(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getProceduralStatus());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        availabilityStatus("availabilityStatus"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setAvailabilityStatus(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getAvailabilityStatus());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        controlStatus("controlStatus"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setControlStatus(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getControlStatus());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        standbyStatus("standbyStatus"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setStandbyStatus(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getStandbyStatus());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        lifecycleStatus("lifecycleStatus"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setLifecycleStatus(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getLifecycleStatus());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        unknownStatus("unknownStatus"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setUnknownStatus(rs.getByte(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setByte(this.getPos(pos), event.getUnknownStatus());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        eventCause("eventCause"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException, IOException, ClassNotFoundException {
                ObjectInputStream inObj = new ObjectInputStream(rs.getBinaryStream(this.columnName()));
                event.setEventCause((Serializable)inObj.readObject());
                inObj.close();
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException, IOException {
                ByteArrayOutputStream buff = new ByteArrayOutputStream();
                ObjectOutputStream outObj = new ObjectOutputStream(buff);
                outObj.writeObject(event.getEventCause());
                outObj.close();
                stat.setBinaryStream(this.getPos(pos), (InputStream)new ByteArrayInputStream(buff.toByteArray()), buff.size());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        }
        ,
        secondaryId("secondaryId"){

            public void readValueFromResultSet(Event event, ResultSet rs) throws SQLException {
                event.setSecondaryId(rs.getLong(this.columnName()));
            }

            public void writeValueToStatement(Event event, PreparedStatement stat, int pos) throws SQLException {
                stat.setLong(this.getPos(pos), event.getSecondaryId());
            }

            public String exportValueToString(Event event, Internationalizer i18n) {
                return "";
            }
        };

        String columnName;

        private Property(String columnName) {
            this.columnName = columnName;
        }

        public String columnName() {
            return this.columnName;
        }

        public String toString() {
            return "Event.Property." + this.name();
        }

        public static Property fromColumnName(String columnName) {
            for (Property prop : Property.values()) {
                if (!prop.columnName().equalsIgnoreCase(columnName)) continue;
                return prop;
            }
            return null;
        }

        public abstract void readValueFromResultSet(Event var1, ResultSet var2) throws Exception;

        public abstract void writeValueToStatement(Event var1, PreparedStatement var2, int var3) throws Exception;

        public abstract String exportValueToString(Event var1, Internationalizer var2);

        protected int getPos(int pos) {
            return pos > 0 ? pos : (this.ordinal() == 0 ? Property.values().length : this.ordinal());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Table {
        Historical(HistoricalEvent.class, "BwHistoricalEvent"),
        Historical2(HistoricalEventSecondary.class, "BwHistoricalEventSecondary"),
        Operational(OperationalEvent.class, "BwOperationalEvent");

        private Class<?> clazz;
        private String tableName;
        private Property[] properties;

        private Table(Class<?> clazz, String defaultName) {
            this.clazz = clazz;
            this.tableName = EntityUtil.getTableName(clazz);
            if (HistoricalEvent.class.equals(clazz)) {
                this.properties = new Property[]{Property.protocol, Property.sequenceNumber, Property.eventTime, Property.receiveTime, Property.eventDescription, Property.objectSeverity, Property.ackTime, Property.clearTime, Property.lastUpdateTime, Property.correlationEventId, Property.deleted, Property.eventCause, Property.probableCause, Property.eventAdvisor, Property.eventNotes, Property.proposedRepairAction, Property.administrativeState, Property.alarmStatus, Property.availabilityStatus, Property.controlStatus, Property.lifecycleStatus, Property.operationalState, Property.proceduralStatus, Property.specificProblem, Property.standbyStatus, Property.unknownStatus, Property.usageState, Property.secondaryId};
            } else if (HistoricalEventSecondary.class.equals(clazz)) {
                this.properties = new Property[]{Property.eventSeverity, Property.locationName, Property.equipmentName, Property.managedObject, Property.sourceIPAddress, Property.eventName, Property.equipmentType, Property.moType, Property.moInstance, Property.moAlias, Property.eventOID, Property.locationId, Property.equipmentId, Property.eventCategory, Property.eventType, Property.ackedBy, Property.clearedBy, Property.userClassifier};
            } else if (OperationalEvent.class.equals(clazz)) {
                this.properties = Property.values();
            }
        }

        public final String tableName() {
            return this.tableName;
        }

        public final Property[] properties() {
            return this.properties;
        }
    }
}

