/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.fault;

import com.bwanms.model.Identifiable;
import com.bwanms.model.fault.CommandArg;
import com.bwanms.validation.WeakLength;
import com.bwanms.validation.WeakNotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true)
@Table(name="BwCommand")
public class Command
implements Serializable,
Identifiable {
    private List<CommandArg> commandArg;
    private long id;
    private String name;
    private String description;
    private String scriptName;
    private String scriptPath;

    @Override
    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @WeakNotNull
    @WeakLength(min=1, max=32)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @WeakNotNull
    @WeakLength(min=1, max=64)
    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    @WeakNotNull
    @WeakLength(min=1, max=256)
    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="command", fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CommandArg> getCommandArg() {
        if (this.commandArg == null) {
            this.commandArg = new ArrayList<CommandArg>();
        }
        return this.commandArg;
    }

    public void setCommandArg(List<CommandArg> commandArg) {
        this.commandArg = commandArg;
    }

    public String toString() {
        return this.getName();
    }
}

