/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.entity.persisters;

import com.bwanms.model.entity.PersisterAdapter;
import com.bwanms.model.fault.nbi.Nbi;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;
import org.hibernate.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbiPersister
extends PersisterAdapter<Nbi> {
    @Override
    public void persistBeforeSave(Nbi entity) throws ServiceException {
        long id;
        Nbi nbi = this.findNbiByName(entity.getName());
        if (nbi != null && ((id = entity.getId()) == 0L || id != nbi.getId())) {
            throw new EntityAlreadyExistsException(entity.getName());
        }
        Datastore.session().evict((Object)nbi);
        super.persistBeforeSave(entity);
    }

    protected Nbi findNbiByName(String name) {
        Query query = Datastore.session().createQuery(" from " + Nbi.class.getName() + " where name = :name ").setString("name", name);
        return (Nbi)query.uniqueResult();
    }
}

