/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.entity.persisters;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.locationmanager.LocationManagerConfig;
import com.bwanms.gui.locationmanager.LocationView;
import com.bwanms.model.Equipment;
import com.bwanms.model.Locatable;
import com.bwanms.model.Location;
import com.bwanms.model.SingleRangeScanTask;
import com.bwanms.model.entity.PersisterAdapter;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.ServiceException;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationPersister
extends PersisterAdapter<Location> {
    @Override
    public void persistBeforeDelete(Location location) throws ServiceException {
        ArrayList match = new ArrayList();
        this.checkLocation(location, match);
        if (match.size() > 0) {
            BitSet matchFlag = new BitSet();
            for (int i = 0; i < match.size(); ++i) {
                Locatable loc = (Locatable)match.get(i);
                if (loc instanceof Equipment) {
                    matchFlag.set(0);
                    break;
                }
                if (!(loc instanceof SingleRangeScanTask)) continue;
                matchFlag.set(1);
            }
            String errorMsgKey = "locationViolation";
            if (matchFlag.get(0)) {
                errorMsgKey = "locationViolationEquipment";
            } else if (matchFlag.get(1)) {
                errorMsgKey = "locationViolationTask";
            }
            Internationalizer i18n = Internationalizer.getInternationalizer(LocationManagerConfig.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString(errorMsgKey, ((Locatable)match.get(0)).getLocation().getName()), Location.class, "", null, null));
            throw new ServerValidationException(iValues);
        }
    }

    private void checkLocation(Location location, List match) {
        match.addAll(this.checkLocationInUse(location));
        for (Location loc : location.getChildren()) {
            this.checkLocation(loc, match);
        }
    }

    private List checkLocationInUse(Location location) {
        return Datastore.session().createQuery(" from " + Locatable.class.getName() + " as locatable where locatable.location=:location").setEntity("location", (Object)location).list();
    }

    @Override
    public void persistBeforeSave(Location location) throws ServiceException {
        List match = Datastore.session().createQuery(" from " + Location.class.getName() + " as location where location.name=:name and location.id!=:id").setString("name", location.getName()).setLong("id", location.getId()).list();
        if (match.size() > 0) {
            Internationalizer i18n = Internationalizer.getInternationalizer(LocationView.class);
            ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
            iValues.add(new InvalidValue(i18n.translateString("uniqueViolation"), Location.class, "name", (Object)location.getName(), (Object)location));
            throw new ServerValidationException(iValues);
        }
        if (location.getParent() != null) {
            Location temp = null;
            try {
                temp = (Location)Datastore.session().get(Location.class, (Serializable)Long.valueOf(location.getParent().getId()));
            }
            catch (HibernateException e) {
                // empty catch block
            }
            if (temp == null) {
                Internationalizer i18n = Internationalizer.getInternationalizer(LocationView.class);
                ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
                iValues.add(new InvalidValue(i18n.translateString("deletedParentException"), Location.class, "name", (Object)location.getName(), (Object)location));
                throw new ServerValidationException(iValues);
            }
        }
    }
}

