/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.entity.persisters;

import com.bwanms.model.entity.PersisterAdapter;
import com.bwanms.model.fault.EventTemplate;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;
import org.hibernate.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTemplatePersister
extends PersisterAdapter<EventTemplate> {
    @Override
    public void persistBeforeSave(EventTemplate entity) throws ServiceException {
        long id;
        EventTemplate templ = this.findEventTemplateByName(entity.getName());
        if (templ != null && ((id = entity.getId()) == 0L || id != templ.getId())) {
            throw new EntityAlreadyExistsException(entity.getName());
        }
        Datastore.session().evict((Object)templ);
        super.persistBeforeSave(entity);
    }

    protected EventTemplate findEventTemplateByName(String name) {
        Query query = Datastore.session().createQuery(" from " + EventTemplate.class.getName() + " where name = :name ").setString("name", name);
        return (EventTemplate)query.uniqueResult();
    }
}

