/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.model.entity.persisters;

import com.bwanms.model.entity.PersisterAdapter;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;
import org.hibernate.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventFilterPersister
extends PersisterAdapter<EventFilter> {
    @Override
    public void persistBeforeSave(EventFilter entity) throws ServiceException {
        long id;
        EventFilter filter = this.findEventFilterByName(entity.getName());
        if (filter != null && ((id = entity.getId()) == 0L || id != filter.getId())) {
            throw new EntityAlreadyExistsException(entity.getName());
        }
        Datastore.session().evict((Object)filter);
        super.persistBeforeSave(entity);
    }

    protected EventFilter findEventFilterByName(String name) {
        Query query = Datastore.session().createQuery(" from " + EventFilter.class.getName() + " where name = :name ").setString("name", name);
        return (EventFilter)query.uniqueResult();
    }
}

